/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.nativebinaries.tasks
import org.gradle.api.Incubating
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.Optional
import org.gradle.nativebinaries.internal.DefaultLinkerSpec
import org.gradle.nativebinaries.internal.LinkerSpec
import org.gradle.nativebinaries.internal.SharedLibraryLinkerSpec

/**
 * Links a binary shared library from object files and imported libraries.
 */
@Incubating
class LinkSharedLibrary extends AbstractLinkTask {
    @Input @Optional
    String installName;

    @Override
    protected LinkerSpec createLinkerSpec() {
        final spec = new Spec()
        spec.installName = getInstallName()
        return spec
    }

    private static class Spec extends DefaultLinkerSpec implements SharedLibraryLinkerSpec {
        String installName;
    }
}
