/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.artifacts.metadata;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.artifacts.ArtifactIdentifier;

/**
 * Meta-data for an artifact that belongs to some module version.
 */
public interface ModuleVersionArtifactMetaData extends ComponentArtifactMetaData {
    ModuleVersionArtifactIdentifier getId();

    /**
     * Converts this artifact to an Ivy artifact. This method is here while we transition away from the Ivy types.
     */
    Artifact toIvyArtifact();

    /**
     * Produces an ArtifactIdentifier for this artifact (it's not actually an identifier - just a bucket of attributes).
     * TODO:ADAM - remove this
     */
    ArtifactIdentifier toArtifactIdentifier();
}
