/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

class InMemoryArtifactsCache {
    private final Map<ComponentArtifactIdentifier, File> artifacts = new HashMap<ComponentArtifactIdentifier, File>();
    private InMemoryCacheStats stats;

    InMemoryArtifactsCache(InMemoryCacheStats stats) {
        this.stats = stats;
    }

    public boolean supplyArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        File fromCache = artifacts.get(id);
        if (fromCache != null) {
            result.resolved(fromCache);
            stats.artifactsServed++;
            return true;
        }
        return false;
    }

    public void newArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        if (result.hasResult() && result.getFailure() == null) {
            artifacts.put(id, result.getFile());
        }
    }
}