/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.connection.AbstractModelProducer;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.converters.TaskPropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildActionRunnerBackedConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ModelProducer modelProducer;

    public BuildActionRunnerBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R12VersionDetails(delegate.getMetaData().getVersion()));
        BuildActionRunnerBackedModelProducer consumerConnectionBackedModelProducer = new BuildActionRunnerBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (BuildActionRunner)((Object)delegate));
        GradleBuildAdapterProducer producerWithGradleBuild = new GradleBuildAdapterProducer(adapter, this.getVersionDetails(), modelMapping, consumerConnectionBackedModelProducer);
        this.modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), modelMapping, producerWithGradleBuild);
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        return this.modelProducer.produceModel(type, operationParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildActionRunnerBackedModelProducer
    extends AbstractModelProducer {
        private final BuildActionRunner buildActionRunner;
        private final Action<SourceObjectMapping> mapper;

        public BuildActionRunnerBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, BuildActionRunner buildActionRunner) {
            super(adapter, versionDetails, modelMapping);
            this.buildActionRunner = buildActionRunner;
            this.mapper = new TaskPropertyHandlerFactory().forVersion(versionDetails);
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (!this.versionDetails.maySupportModel(type)) {
                throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
            }
            Class<?> protocolType = this.modelMapping.getProtocolType(type);
            Object model = this.buildActionRunner.run(protocolType, operationParameters).getModel();
            return this.adapter.adapt(type, model, this.mapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R12VersionDetails
    extends VersionDetails {
        public R12VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsGradleProjectModel() {
            return true;
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType.equals(ProjectOutcomes.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(BuildEnvironment.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }
}

