/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeplatform.filesystem;

import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.PosixFiles;
import org.gradle.api.JavaVersion;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.nativeplatform.filesystem.EmptyChmod;
import org.gradle.internal.nativeplatform.filesystem.FallbackFileCanonicalizer;
import org.gradle.internal.nativeplatform.filesystem.FallbackStat;
import org.gradle.internal.nativeplatform.filesystem.FileCanonicalizer;
import org.gradle.internal.nativeplatform.filesystem.FileModeAccessor;
import org.gradle.internal.nativeplatform.filesystem.FileModeMutator;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.nativeplatform.filesystem.GenericFileSystem;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedChmod;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedStat;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedSymlink;
import org.gradle.internal.nativeplatform.filesystem.UnsupportedFilePermissions;
import org.gradle.internal.nativeplatform.filesystem.UnsupportedSymlink;
import org.gradle.internal.nativeplatform.filesystem.WindowsSymlink;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemServices.class);

    public FileCanonicalizer createFileCanonicalizer() {
        return (FileCanonicalizer)this.newInstance("org.gradle.internal.nativeplatform.filesystem.jdk7.Jdk7FileCanonicalizer", FallbackFileCanonicalizer.class);
    }

    public FileSystem createFileSystem(OperatingSystem operatingSystem) throws Exception {
        if (operatingSystem.isWindows()) {
            return new GenericFileSystem(new EmptyChmod(), new FallbackStat(), new WindowsSymlink());
        }
        try {
            PosixFiles posixFiles = (PosixFiles)Native.get(PosixFiles.class);
            NativePlatformBackedSymlink symlink = new NativePlatformBackedSymlink(posixFiles);
            NativePlatformBackedChmod chmod = new NativePlatformBackedChmod(posixFiles);
            NativePlatformBackedStat stat = new NativePlatformBackedStat(posixFiles);
            return new GenericFileSystem(chmod, stat, symlink);
        }
        catch (NativeIntegrationUnavailableException ex) {
            LOGGER.debug("Native-platform file system integration is not available. Continuing with fallback.");
            LOGGER.debug("Using UnsupportedSymlink implementation.");
            UnsupportedSymlink symlink = new UnsupportedSymlink();
            Object handler = this.newInstance("org.gradle.internal.nativeplatform.filesystem.jdk7.PosixJdk7FilePermissionHandler", UnsupportedFilePermissions.class);
            return new GenericFileSystem((FileModeMutator)handler, (FileModeAccessor)handler, symlink);
        }
    }

    private Object newInstance(String jdk7Type, Class<?> fallbackType) {
        Class<?> handlerClass = null;
        if (JavaVersion.current().isJava7()) {
            try {
                handlerClass = FileSystemServices.class.getClassLoader().loadClass(jdk7Type);
                LOGGER.debug("Using JDK 7 file service {}", (Object)jdk7Type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (handlerClass == null) {
            LOGGER.debug("Unable to load {}. Continuing with fallback {}.", (Object)jdk7Type, (Object)fallbackType.getName());
            handlerClass = fallbackType;
        }
        try {
            return handlerClass.newInstance();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

