/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.connection;

import java.util.Collections;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

public class BuildLogLevelMixIn {
    private final ProviderOperationParameters parameters;

    public BuildLogLevelMixIn(ProviderOperationParameters parameters) {
        this.parameters = parameters;
    }

    public LogLevel getBuildLogLevel() {
        LoggingCommandLineConverter converter = new LoggingCommandLineConverter();
        CommandLineParser parser = new CommandLineParser().allowUnknownOptions().allowMixedSubcommandsAndOptions();
        converter.configure(parser);
        ParsedCommandLine parsedCommandLine = parser.parse(this.parameters.getArguments(Collections.<String>emptyList()));
        if (this.parameters.getVerboseLogging(false) && !parsedCommandLine.hasAnyOption(converter.getLogLevelOptions())) {
            return LogLevel.DEBUG;
        }
        LoggingConfiguration loggingConfiguration = converter.convert(parsedCommandLine, new LoggingConfiguration());
        return loggingConfiguration.getLogLevel();
    }
}

