/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.JavaVersion;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.FixedBuildCancellationToken;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.nativeplatform.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConfigurableConnection;
import org.gradle.tooling.internal.protocol.ConnectionMetaDataVersion1;
import org.gradle.tooling.internal.protocol.ConnectionParameters;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionExecutor;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalCancellationToken;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.ProjectVersion3;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.provider.ConnectionScopeServices;
import org.gradle.tooling.internal.provider.DefaultConnectionMetaData;
import org.gradle.tooling.internal.provider.InternalCancellationTokenAdapter;
import org.gradle.tooling.internal.provider.ProviderConnection;
import org.gradle.tooling.internal.provider.connection.AdaptedOperationParameters;
import org.gradle.tooling.internal.provider.connection.BuildLogLevelMixIn;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.internal.provider.connection.ProviderConnectionParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnection
implements InternalConnection,
BuildActionRunner,
ConfigurableConnection,
ModelBuilder,
InternalBuildActionExecutor,
InternalCancellableConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnection.class);
    private final ProtocolToModelAdapter adapter;
    private final ServiceRegistry services;
    private final ProviderConnection connection;

    public DefaultConnection() {
        LOGGER.debug("Tooling API provider {} created.", (Object)GradleVersion.current().getVersion());
        LoggingServiceRegistry loggingServices = LoggingServiceRegistry.newEmbeddableLogging();
        this.services = ServiceRegistryBuilder.builder().displayName("Connection services").parent(loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider(new ConnectionScopeServices(loggingServices)).build();
        this.adapter = this.services.get(ProtocolToModelAdapter.class);
        this.connection = this.services.get(ProviderConnection.class);
    }

    public void configure(ConnectionParameters parameters) {
        ProviderConnectionParameters providerConnectionParameters = (ProviderConnectionParameters)this.adapter.adapt(ProviderConnectionParameters.class, (Object)parameters);
        this.connection.configure(providerConnectionParameters);
    }

    public void configureLogging(boolean verboseLogging) {
    }

    public ConnectionMetaDataVersion1 getMetaData() {
        return new DefaultConnectionMetaData();
    }

    public void stop() {
    }

    @Deprecated
    public void executeBuild(BuildParametersVersion1 buildParameters, BuildOperationParametersVersion1 operationParameters) {
        throw this.unsupportedConnectionException();
    }

    @Deprecated
    public ProjectVersion3 getModel(Class<? extends ProjectVersion3> type, BuildOperationParametersVersion1 parameters) {
        throw this.unsupportedConnectionException();
    }

    @Deprecated
    public <T> T getTheModel(Class<T> type, BuildOperationParametersVersion1 parameters) {
        throw this.unsupportedConnectionException();
    }

    private <T> T run(Class<T> type, BuildOperationParametersVersion1 parameters) {
        String modelName = new ModelMapping().getModelNameFromProtocolType(type);
        return (T)this.connection.run(modelName, (BuildCancellationToken)new FixedBuildCancellationToken(), (ProviderOperationParameters)new AdaptedOperationParameters(parameters));
    }

    @Deprecated
    public <T> BuildResult<T> run(Class<T> type, BuildParameters buildParameters) throws UnsupportedOperationException, IllegalStateException {
        this.validateCanRun();
        ProviderOperationParameters providerParameters = this.toProviderParameters(buildParameters);
        String modelName = new ModelMapping().getModelNameFromProtocolType(type);
        Object result = this.connection.run(modelName, (BuildCancellationToken)new FixedBuildCancellationToken(), providerParameters);
        return new ProviderBuildResult<Object>(result);
    }

    public BuildResult<?> getModel(ModelIdentifier modelIdentifier, BuildParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        this.validateCanRun();
        ProviderOperationParameters providerParameters = this.toProviderParameters(operationParameters);
        Object result = this.connection.run(modelIdentifier.getName(), (BuildCancellationToken)new FixedBuildCancellationToken(), providerParameters);
        return new ProviderBuildResult<Object>(result);
    }

    public BuildResult<?> getModel(ModelIdentifier modelIdentifier, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedModelException, InternalUnsupportedBuildArgumentException, IllegalStateException {
        this.validateCanRun();
        ProviderOperationParameters providerParameters = this.toProviderParameters(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object result = this.connection.run(modelIdentifier.getName(), (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(result);
    }

    public <T> BuildResult<T> run(InternalBuildAction<T> action, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        this.validateCanRun();
        ProviderOperationParameters providerParameters = this.toProviderParameters(operationParameters);
        Object results = this.connection.run(action, (BuildCancellationToken)new FixedBuildCancellationToken(), providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    public <T> BuildResult<T> run(InternalBuildAction<T> action, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        this.validateCanRun();
        ProviderOperationParameters providerParameters = this.toProviderParameters(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.run(action, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    private void validateCanRun() {
        LOGGER.info("Tooling API is using target Gradle version: {}.", (Object)GradleVersion.current().getVersion());
        if (!JavaVersion.current().isJava6Compatible()) {
            throw UnsupportedJavaRuntimeException.usingUnsupportedVersion("Gradle", JavaVersion.VERSION_1_6);
        }
    }

    private UnsupportedVersionException unsupportedConnectionException() {
        return new UnsupportedVersionException("Support for clients using a tooling API version older than 1.2 was removed in Gradle 2.0. You should upgrade your tooling API client to version 1.2 or later.");
    }

    private ProviderOperationParameters toProviderParameters(BuildParameters buildParameters) {
        return (ProviderOperationParameters)this.adapter.adapt(ProviderOperationParameters.class, (Object)buildParameters, BuildLogLevelMixIn.class);
    }
}

