/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.initialization.BuildAction;
import org.gradle.initialization.BuildController;
import org.gradle.initialization.DefaultCommandLineConverter;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.launcher.cli.converter.PropertiesToStartParameterConverter;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfiguringBuildAction<T>
implements BuildAction<T>,
Serializable {
    private LogLevel buildLogLevel;
    private List<String> arguments;
    private List<String> tasks;
    private List<InternalLaunchable> launchables;
    private BuildAction<? extends T> action;
    private File projectDirectory;
    private File gradleUserHomeDir;
    private Boolean searchUpwards;
    private Map<String, String> properties = new HashMap<String, String>();
    private final StartParameter startParameterTemplate = new StartParameter();

    public ConfiguringBuildAction() {
    }

    public ConfiguringBuildAction(ProviderOperationParameters parameters, BuildAction<? extends T> action, Map<String, String> properties) {
        this.properties.putAll(properties);
        this.gradleUserHomeDir = parameters.getGradleUserHomeDir();
        this.projectDirectory = parameters.getProjectDir();
        this.searchUpwards = parameters.isSearchUpwards();
        this.buildLogLevel = parameters.getBuildLogLevel();
        this.arguments = parameters.getArguments(Collections.<String>emptyList());
        this.tasks = parameters.getTasks();
        this.launchables = parameters.getLaunchables(null);
        this.action = action;
    }

    StartParameter configureStartParameter() {
        return this.configureStartParameter(new PropertiesToStartParameterConverter());
    }

    StartParameter configureStartParameter(PropertiesToStartParameterConverter propertiesToStartParameterConverter) {
        StartParameter startParameter = this.startParameterTemplate.newInstance();
        startParameter.setProjectDir(this.projectDirectory);
        if (this.gradleUserHomeDir != null) {
            startParameter.setGradleUserHomeDir(this.gradleUserHomeDir);
        }
        if (this.launchables != null) {
            startParameter.setTaskRequests(Iterables.transform(this.launchables, (Function)new Function<InternalLaunchable, TaskExecutionRequest>(){

                public TaskExecutionRequest apply(InternalLaunchable launchable) {
                    if (launchable instanceof TaskExecutionRequest) {
                        TaskExecutionRequest originalLaunchable = (TaskExecutionRequest)launchable;
                        DefaultTaskExecutionRequest launchableImpl = new DefaultTaskExecutionRequest(originalLaunchable.getArgs(), originalLaunchable.getProjectPath());
                        return launchableImpl;
                    }
                    throw new InternalUnsupportedBuildArgumentException("Problem with provided launchable arguments: " + ConfiguringBuildAction.this.launchables + ". " + "\nOnly objects from this provider can be built.");
                }
            }));
        } else if (this.tasks != null) {
            startParameter.setTaskNames(this.tasks);
        }
        propertiesToStartParameterConverter.convert(this.properties, startParameter);
        if (this.arguments != null) {
            DefaultCommandLineConverter converter = new DefaultCommandLineConverter();
            try {
                converter.convert(this.arguments, startParameter);
            }
            catch (CommandLineArgumentException e) {
                throw new InternalUnsupportedBuildArgumentException("Problem with provided build arguments: " + this.arguments + ". " + "\n" + e.getMessage() + "\nEither it is not a valid build option or it is not supported in the target Gradle version." + "\nNot all of the Gradle command line options are supported build arguments." + "\nExamples of supported build arguments: '--info', '-u', '-p'." + "\nExamples of unsupported build options: '--daemon', '-?', '-v'." + "\nPlease find more information in the javadoc for the BuildLauncher class.", (Throwable)e);
            }
        }
        if (this.searchUpwards != null) {
            startParameter.setSearchUpwards(this.searchUpwards);
        }
        if (this.buildLogLevel != null) {
            startParameter.setLogLevel(this.buildLogLevel);
        }
        return startParameter;
    }

    @Override
    public T run(BuildController buildController) {
        buildController.setStartParameter(this.configureStartParameter());
        return this.action.run(buildController);
    }
}

