/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildAction;
import org.gradle.initialization.BuildController;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.DefaultBuildController;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.internal.provider.SerializedPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientProvidedBuildAction
implements BuildAction<BuildActionResult>,
Serializable {
    private final SerializedPayload action;

    public ClientProvidedBuildAction(SerializedPayload action) {
        this.action = action;
    }

    @Override
    public BuildActionResult run(BuildController buildController) {
        GradleInternal gradle = buildController.getGradle();
        PayloadSerializer payloadSerializer = gradle.getServices().get(PayloadSerializer.class);
        InternalBuildAction action = (InternalBuildAction)payloadSerializer.deserialize(this.action);
        gradle.addListener(new ModelConfigurationListener(){

            public void onConfigure(GradleInternal gradle) {
                ClientProvidedBuildAction.this.ensureAllProjectsEvaluated(gradle);
            }
        });
        buildController.configure();
        DefaultBuildController internalBuildController = new DefaultBuildController(gradle);
        Object model = null;
        InternalBuildActionFailureException failure = null;
        try {
            model = action.execute((InternalBuildController)internalBuildController);
        }
        catch (RuntimeException e) {
            failure = new InternalBuildActionFailureException((Throwable)e);
        }
        if (failure != null) {
            return new BuildActionResult(null, payloadSerializer.serialize(failure));
        }
        return new BuildActionResult(payloadSerializer.serialize(model), null);
    }

    private void ensureAllProjectsEvaluated(GradleInternal gradle) {
        gradle.getRootProject().allprojects((Action<? super Project>)new Action<ProjectInternal>(){

            @Override
            public void execute(ProjectInternal projectInternal) {
                projectInternal.evaluate();
            }
        });
    }
}

