/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildAction;
import org.gradle.initialization.BuildController;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.model.internal.ProjectSensitiveToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildModelAction
implements BuildAction<BuildActionResult>,
Serializable {
    private final boolean runTasks;
    private final String modelName;

    public BuildModelAction(String modelName, boolean runTasks) {
        this.modelName = modelName;
        this.runTasks = runTasks;
    }

    @Override
    public BuildActionResult run(BuildController buildController) {
        ToolingModelBuilder builder;
        GradleInternal gradle = buildController.getGradle();
        if (this.runTasks) {
            buildController.run();
        } else {
            gradle.addListener(new ModelConfigurationListener(){

                public void onConfigure(GradleInternal gradle) {
                    BuildModelAction.this.ensureAllProjectsEvaluated(gradle);
                }
            });
            buildController.configure();
        }
        ToolingModelBuilderRegistry builderRegistry = this.getToolingModelBuilderRegistry(gradle);
        try {
            builder = builderRegistry.getBuilder(this.modelName);
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
        Object result = builder instanceof ProjectSensitiveToolingModelBuilder ? ((ProjectSensitiveToolingModelBuilder)builder).buildAll(this.modelName, (Project)gradle.getDefaultProject(), true) : builder.buildAll(this.modelName, gradle.getDefaultProject());
        PayloadSerializer payloadSerializer = gradle.getServices().get(PayloadSerializer.class);
        return new BuildActionResult(payloadSerializer.serialize(result), null);
    }

    private ToolingModelBuilderRegistry getToolingModelBuilderRegistry(GradleInternal gradle) {
        return gradle.getDefaultProject().getServices().get(ToolingModelBuilderRegistry.class);
    }

    private void ensureAllProjectsEvaluated(GradleInternal gradle) {
        gradle.getRootProject().allprojects((Action<? super Project>)new Action<ProjectInternal>(){

            @Override
            public void execute(ProjectInternal projectInternal) {
                projectInternal.evaluate();
            }
        });
    }
}

