/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildAction;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildController;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.ReportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final GradleLauncherFactory gradleLauncherFactory;

    public InProcessBuildActionExecuter(GradleLauncherFactory gradleLauncherFactory) {
        this.gradleLauncherFactory = gradleLauncherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(BuildAction<T> action, BuildCancellationToken cancellationToken, BuildActionParameters actionParameters) {
        DefaultBuildController buildController = new DefaultBuildController(this.gradleLauncherFactory, cancellationToken, actionParameters);
        try {
            T t = action.run(buildController);
            return t;
        }
        finally {
            buildController.stop();
        }
    }

    private static class DefaultBuildController
    implements BuildController,
    Stoppable {
        private State state = State.NotStarted;
        private final BuildActionParameters actionParameters;
        private final GradleLauncherFactory gradleLauncherFactory;
        private final BuildCancellationToken cancellationToken;
        private DefaultGradleLauncher gradleLauncher;
        private StartParameter startParameter = new StartParameter();

        private DefaultBuildController(GradleLauncherFactory gradleLauncherFactory, BuildCancellationToken cancellationToken, BuildActionParameters actionParameters) {
            this.gradleLauncherFactory = gradleLauncherFactory;
            this.cancellationToken = cancellationToken;
            this.actionParameters = actionParameters;
        }

        public void setStartParameter(StartParameter startParameter) {
            if (this.state != State.NotStarted) {
                throw new IllegalStateException("Cannot change start parameter after build has started.");
            }
            this.startParameter = startParameter;
        }

        public DefaultGradleLauncher getLauncher() {
            if (this.state == State.Completed) {
                throw new IllegalStateException("Cannot use launcher after build has completed.");
            }
            if (this.state == State.NotStarted) {
                this.gradleLauncher = (DefaultGradleLauncher)this.gradleLauncherFactory.newInstance(this.startParameter, this.cancellationToken, this.actionParameters.getBuildRequestMetaData());
                this.state = State.Created;
            }
            return this.gradleLauncher;
        }

        public GradleInternal getGradle() {
            return this.getLauncher().getGradle();
        }

        public GradleInternal run() {
            return this.check(this.getLauncher().run());
        }

        public GradleInternal configure() {
            return this.check(this.getLauncher().getBuildAnalysis());
        }

        private GradleInternal check(BuildResult buildResult) {
            this.state = State.Completed;
            if (buildResult.getFailure() != null) {
                throw new ReportedException(buildResult.getFailure());
            }
            return (GradleInternal)buildResult.getGradle();
        }

        public void stop() {
            CompositeStoppable.stoppable(this.gradleLauncher).stop();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            NotStarted,
            Created,
            Completed;

        }
    }
}

