/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.ReportedException;
import org.gradle.tooling.BuildCancelledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteBuild
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(ExecuteBuild.class);
    private final BuildActionExecuter<BuildActionParameters> actionExecuter;

    public ExecuteBuild(BuildActionExecuter<BuildActionParameters> actionExecuter) {
        this.actionExecuter = actionExecuter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        LOGGER.info("Executing build with daemon context: {}", execution.getDaemonContext());
        try {
            BuildCancellationToken cancellationToken = execution.getDaemonStateControl().updateCancellationToken(build.getIdentifier());
            Object result = this.actionExecuter.execute(build.getAction(), cancellationToken, build.getParameters());
            if (cancellationToken.isCancellationRequested()) {
                execution.setException((Throwable)new BuildCancelledException("Build cancelled."));
            } else {
                execution.setResult(result);
            }
        }
        catch (ReportedException e) {
            execution.setException(e);
        }
        finally {
            LOGGER.debug("The daemon has finished executing the build.");
        }
        execution.proceed();
    }
}

