/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.nativeplatform.ProcessEnvironment;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.server.exec.CatchAndForwardDaemonFailure;
import org.gradle.launcher.daemon.server.exec.DaemonCommandAction;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.DaemonConnection;
import org.gradle.launcher.daemon.server.exec.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.EstablishBuildEnvironment;
import org.gradle.launcher.daemon.server.exec.ExecuteBuild;
import org.gradle.launcher.daemon.server.exec.ForwardClientInput;
import org.gradle.launcher.daemon.server.exec.HandleCancel;
import org.gradle.launcher.daemon.server.exec.HandleStop;
import org.gradle.launcher.daemon.server.exec.LogToClient;
import org.gradle.launcher.daemon.server.exec.ResetDeprecationLogger;
import org.gradle.launcher.daemon.server.exec.ReturnResult;
import org.gradle.launcher.daemon.server.exec.StartBuildOrRespondWithBusy;
import org.gradle.launcher.daemon.server.exec.StartStopIfBuildAndStop;
import org.gradle.launcher.daemon.server.exec.WatchForDisconnection;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.LoggingOutputInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonCommandExecuter
implements DaemonCommandExecuter {
    private final LoggingOutputInternal loggingOutput;
    private final BuildActionExecuter<BuildActionParameters> actionExecuter;
    private DaemonCommandAction hygieneAction;
    private final ProcessEnvironment processEnvironment;
    private final File daemonLog;

    public DefaultDaemonCommandExecuter(BuildActionExecuter<BuildActionParameters> actionExecuter, ProcessEnvironment processEnvironment, LoggingManagerInternal loggingOutput, File daemonLog, DaemonCommandAction hygieneAction) {
        this.processEnvironment = processEnvironment;
        this.daemonLog = daemonLog;
        this.loggingOutput = loggingOutput;
        this.actionExecuter = actionExecuter;
        this.hygieneAction = hygieneAction;
    }

    @Override
    public void executeCommand(DaemonConnection connection, Command command, DaemonContext daemonContext, DaemonStateControl daemonStateControl, Runnable commandAbandoned) {
        new DaemonCommandExecution(connection, command, daemonContext, daemonStateControl, commandAbandoned, this.createActions(daemonContext)).proceed();
    }

    protected List<DaemonCommandAction> createActions(DaemonContext daemonContext) {
        DaemonDiagnostics daemonDiagnostics = new DaemonDiagnostics(this.daemonLog, daemonContext.getPid());
        return new LinkedList<DaemonCommandAction>(Arrays.asList(new CatchAndForwardDaemonFailure(), this.hygieneAction, new HandleStop(), new HandleCancel(), new StartBuildOrRespondWithBusy(daemonDiagnostics), new EstablishBuildEnvironment(this.processEnvironment), new LogToClient(this.loggingOutput, daemonDiagnostics), new ForwardClientInput(), new ReturnResult(), new StartStopIfBuildAndStop(), new ResetDeprecationLogger(), new WatchForDisconnection(), new ExecuteBuild(this.actionExecuter)));
    }
}

