/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.IoCommand;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.server.exec.DaemonConnection;
import org.gradle.launcher.daemon.server.exec.StdinHandler;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonConnection
implements DaemonConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDaemonConnection.class);
    private final Connection<Object> connection;
    private final StoppableExecutor executor;
    private final StdinQueue stdinQueue;
    private final DisconnectQueue disconnectQueue;
    private final ReceiveQueue receiveQueue;

    public DefaultDaemonConnection(final Connection<Object> connection, ExecutorFactory executorFactory) {
        this.connection = connection;
        this.stdinQueue = new StdinQueue(executorFactory);
        this.disconnectQueue = new DisconnectQueue();
        this.receiveQueue = new ReceiveQueue();
        this.executor = executorFactory.create("Handler for " + connection.toString());
        this.executor.execute(new Runnable(){

            public void run() {
                Exception failure = null;
                try {
                    while (true) {
                        Object message;
                        try {
                            message = connection.receive();
                        }
                        catch (Exception e) {
                            LOGGER.debug("Could not receive message from client.", (Throwable)e);
                            failure = e;
                            DefaultDaemonConnection.this.stdinQueue.disconnect();
                            DefaultDaemonConnection.this.disconnectQueue.disconnect();
                            DefaultDaemonConnection.this.receiveQueue.disconnect(failure);
                            return;
                        }
                        if (message == null) {
                            LOGGER.debug("Received end-of-input from client.");
                            return;
                        }
                        if (!(message instanceof IoCommand)) {
                            LOGGER.debug("Received non-IO message from client: {}", message);
                            DefaultDaemonConnection.this.receiveQueue.add(message);
                            continue;
                        }
                        LOGGER.debug("Received IO message from client: {}", message);
                        DefaultDaemonConnection.this.stdinQueue.add((IoCommand)message);
                    }
                }
                finally {
                    DefaultDaemonConnection.this.stdinQueue.disconnect();
                    DefaultDaemonConnection.this.disconnectQueue.disconnect();
                    DefaultDaemonConnection.this.receiveQueue.disconnect(failure);
                }
            }
        });
    }

    @Override
    public void onStdin(StdinHandler handler) {
        this.stdinQueue.useHandler(handler);
    }

    @Override
    public void onDisconnect(Runnable handler) {
        this.disconnectQueue.useHandler(handler);
    }

    @Override
    public Object receive(long timeoutValue, TimeUnit timeoutUnits) {
        return this.receiveQueue.take(timeoutValue, timeoutUnits);
    }

    @Override
    public void daemonUnavailable(DaemonUnavailable unavailable) {
        this.connection.dispatch((Object)unavailable);
    }

    @Override
    public void buildStarted(BuildStarted buildStarted) {
        this.connection.dispatch((Object)buildStarted);
    }

    @Override
    public void logEvent(OutputEvent logEvent) {
        this.connection.dispatch((Object)logEvent);
    }

    @Override
    public void completed(Result result) {
        this.connection.dispatch((Object)result);
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.disconnectQueue, this.connection, this.executor, this.receiveQueue, this.stdinQueue).stop();
    }

    private static class ReceiveQueue
    implements Stoppable {
        private static final Object END = new Object();
        private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();

        private ReceiveQueue() {
        }

        public void stop() {
        }

        public void disconnect(Throwable failure) {
            this.queue.clear();
            if (failure != null) {
                this.add(failure);
            }
            this.add(END);
        }

        public void add(Object message) {
            try {
                this.queue.put(message);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        public Object take(long timeoutValue, TimeUnit timeoutUnits) {
            Object result;
            try {
                result = this.queue.poll(timeoutValue, timeoutUnits);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            if (result instanceof Throwable) {
                Throwable failure = (Throwable)result;
                throw UncheckedException.throwAsUncheckedException(failure);
            }
            return result == END ? null : result;
        }
    }

    private static class DisconnectQueue
    implements Stoppable {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private Runnable handler;
        private boolean notifying;
        private boolean disconnected;

        private DisconnectQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            Runnable action;
            this.lock.lock();
            try {
                this.disconnected = true;
                if (this.handler == null) {
                    return;
                }
                action = this.handler;
                this.notifying = true;
            }
            finally {
                this.lock.unlock();
            }
            this.runAction(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runAction(Runnable action) {
            try {
                action.run();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to notify disconnect handler.", (Throwable)e);
            }
            finally {
                this.lock.lock();
                try {
                    this.notifying = false;
                    this.condition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public void stop() {
            this.useHandler(null);
        }

        public void useHandler(Runnable handler) {
            if (handler != null) {
                this.startMonitoring(handler);
            } else {
                this.stopMonitoring();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startMonitoring(Runnable handler) {
            Runnable action;
            this.lock.lock();
            try {
                if (this.handler != null) {
                    throw new UnsupportedOperationException("Multiple disconnect handlers not supported.");
                }
                this.handler = handler;
                if (!this.disconnected) {
                    return;
                }
                action = handler;
                this.notifying = true;
            }
            finally {
                this.lock.unlock();
            }
            this.runAction(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopMonitoring() {
            this.lock.lock();
            try {
                while (this.notifying) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
                this.handler = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class StdinQueue
    implements Stoppable {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private final LinkedList<IoCommand> stdin = new LinkedList();
        private StoppableExecutor executor;
        private boolean removed;
        private final ExecutorFactory executorFactory;

        private StdinQueue(ExecutorFactory executorFactory) {
            this.executorFactory = executorFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            StoppableExecutor executor;
            this.lock.lock();
            try {
                executor = this.executor;
            }
            finally {
                this.lock.unlock();
            }
            if (executor != null) {
                executor.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IoCommand command) {
            this.lock.lock();
            try {
                this.stdin.add(command);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void useHandler(StdinHandler handler) {
            if (handler != null) {
                this.startConsuming(handler);
            } else {
                this.stopConsuming();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopConsuming() {
            StoppableExecutor executor;
            this.lock.lock();
            try {
                this.stdin.clear();
                this.removed = true;
                this.condition.signalAll();
                executor = this.executor;
            }
            finally {
                this.lock.unlock();
            }
            if (executor != null) {
                executor.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startConsuming(final StdinHandler handler) {
            this.lock.lock();
            try {
                if (this.executor != null) {
                    throw new UnsupportedOperationException("Multiple stdin handlers not supported.");
                }
                this.executor = this.executorFactory.create("Stdin handler");
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            IoCommand command;
                            StdinQueue.this.lock.lock();
                            try {
                                while (!StdinQueue.this.removed && StdinQueue.this.stdin.isEmpty()) {
                                    try {
                                        StdinQueue.this.condition.await();
                                    }
                                    catch (InterruptedException e) {
                                        throw UncheckedException.throwAsUncheckedException(e);
                                    }
                                }
                                if (StdinQueue.this.removed) {
                                    return;
                                }
                                command = (IoCommand)StdinQueue.this.stdin.removeFirst();
                            }
                            finally {
                                StdinQueue.this.lock.unlock();
                            }
                            try {
                                if (command instanceof CloseInput) {
                                    handler.onEndOfInput();
                                    return;
                                }
                                handler.onInput((ForwardInput)command);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Could not forward client stdin.", (Throwable)e);
                                return;
                            }
                        }
                    }
                });
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            this.lock.lock();
            try {
                this.stdin.clear();
                this.stdin.add(new CloseInput("<disconnected>"));
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

