/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.io.File;
import java.util.UUID;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.nativeplatform.ProcessEnvironment;
import org.gradle.internal.nativeplatform.services.NativeServices;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonContextBuilder;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonTcpServerConnector;
import org.gradle.launcher.daemon.server.exec.DaemonHygieneAction;
import org.gradle.launcher.daemon.server.exec.DefaultDaemonCommandExecuter;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.logging.LoggingManagerInternal;

public class DaemonServices
extends DefaultServiceRegistry {
    private final DaemonServerConfiguration configuration;
    private final LoggingManagerInternal loggingManager;
    private static final Logger LOGGER = Logging.getLogger(DaemonServices.class);

    public DaemonServices(DaemonServerConfiguration configuration, ServiceRegistry loggingServices, LoggingManagerInternal loggingManager) {
        super(new ServiceRegistry[]{NativeServices.getInstance(), loggingServices});
        this.configuration = configuration;
        this.loggingManager = loggingManager;
        this.addProvider(new DaemonRegistryServices(configuration.getBaseDir()));
        this.addProvider(new GlobalScopeServices(true));
    }

    protected DaemonContext createDaemonContext() {
        DaemonContextBuilder builder = new DaemonContextBuilder(this.get(ProcessEnvironment.class));
        builder.setDaemonRegistryDir(this.configuration.getBaseDir());
        builder.setIdleTimeout(this.configuration.getIdleTimeout());
        builder.setUid(this.configuration.getUid());
        LOGGER.debug("Creating daemon context with opts: {}", this.configuration.getJvmOptions());
        builder.setDaemonOpts(this.configuration.getJvmOptions());
        return builder.create();
    }

    public File getDaemonLogFile() {
        DaemonContext daemonContext = this.get(DaemonContext.class);
        Long pid = daemonContext.getPid();
        String fileName = String.format("daemon-%s.out.log", pid == null ? UUID.randomUUID() : pid);
        return new File(this.get(DaemonDir.class).getVersionedDir(), fileName);
    }

    protected Daemon createDaemon() {
        return new Daemon(new DaemonTcpServerConnector(), this.get(DaemonRegistry.class), this.get(DaemonContext.class), "password", new DefaultDaemonCommandExecuter(new InProcessBuildActionExecuter(this.get(GradleLauncherFactory.class)), this.get(ProcessEnvironment.class), this.loggingManager, this.getDaemonLogFile(), new DaemonHygieneAction()), this.get(ExecutorFactory.class));
    }
}

