/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import java.util.Collection;
import java.util.Collections;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.launcher.daemon.context.DaemonContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonUidCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final ExplainingSpec<DaemonContext> delegateSpec;
    private final ExplainingSpec<String> uidSpec;

    public static ExplainingSpec<DaemonContext> createSpecRequiringUid(ExplainingSpec<DaemonContext> delegateSpec, String desiredUid) {
        return new DaemonUidCompatibilitySpec(delegateSpec, new UidRestrictionSpec(true, Collections.singleton(desiredUid)));
    }

    public static ExplainingSpec<DaemonContext> createSpecRejectingUids(ExplainingSpec<DaemonContext> delegateSpec, Collection<String> desiredUids) {
        return new DaemonUidCompatibilitySpec(delegateSpec, new UidRestrictionSpec(false, desiredUids));
    }

    public DaemonUidCompatibilitySpec(ExplainingSpec<DaemonContext> delegateSpec, ExplainingSpec<String> uidSpec) {
        this.delegateSpec = delegateSpec;
        this.uidSpec = uidSpec;
    }

    @Override
    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.delegateSpec.isSatisfiedBy(potentialContext) && this.uidSpec.isSatisfiedBy(potentialContext.getUid());
    }

    @Override
    public String whyUnsatisfied(DaemonContext context) {
        String unsatisfiedDesc = this.uidSpec.whyUnsatisfied(context.getUid());
        if (unsatisfiedDesc != null) {
            return "Different daemon instance. " + unsatisfiedDesc;
        }
        return this.delegateSpec.whyUnsatisfied(context);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.delegateSpec.toString() + "," + this.uidSpec.toString() + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UidRestrictionSpec
    implements ExplainingSpec<String> {
        private final boolean required;
        private final Collection<String> uids;

        public UidRestrictionSpec(boolean required, Collection<String> uids) {
            this.required = required;
            this.uids = uids;
        }

        @Override
        public String whyUnsatisfied(String uid) {
            if (!this.isSatisfiedBy(uid)) {
                return "UID restriction does not hold.\n" + this.description(uid);
            }
            return null;
        }

        private String description(String uid) {
            return (this.required ? "Required: " : "Rejected: ") + this.uids + "\n" + "Actual: " + uid + "\n";
        }

        @Override
        public boolean isSatisfiedBy(String uid) {
            return this.uids.contains(uid) == this.required;
        }
    }
}

