/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.gradle.internal.Factory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeplatform.ProcessEnvironment;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonContextBuilder
implements Factory<DaemonContext> {
    private String uid;
    private File javaHome;
    private File daemonRegistryDir;
    private Long pid;
    private Integer idleTimeout;
    private Locale locale = Locale.getDefault();
    private List<String> daemonOpts = Lists.newArrayList();

    public DaemonContextBuilder(ProcessEnvironment processEnvironment) {
        this.javaHome = GFileUtils.canonicalise(Jvm.current().getJavaHome());
        this.pid = processEnvironment.maybeGetPid();
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public File getDaemonRegistryDir() {
        return this.daemonRegistryDir;
    }

    public void setDaemonRegistryDir(File daemonRegistryDir) {
        this.daemonRegistryDir = daemonRegistryDir;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    public void setDaemonOpts(List<String> daemonOpts) {
        this.daemonOpts = daemonOpts;
    }

    public void useDaemonParameters(DaemonParameters daemonParameters) {
        this.setJavaHome(daemonParameters.getEffectiveJavaHome());
        this.setDaemonOpts(daemonParameters.getEffectiveJvmArgs());
    }

    @Override
    public DaemonContext create() {
        if (this.daemonRegistryDir == null) {
            throw new IllegalStateException("Registry dir must be specified.");
        }
        return new DefaultDaemonContext(this.uid, this.javaHome, this.daemonRegistryDir, this.pid, this.idleTimeout, this.daemonOpts);
    }
}

