/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.internal.JvmOptions;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonParameters {
    static final int DEFAULT_IDLE_TIMEOUT = 10800000;
    public static final List<String> DEFAULT_JVM_ARGS = ImmutableList.of((Object)"-Xmx1024m", (Object)"-XX:MaxPermSize=256m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    private final String uid;
    private File baseDir;
    private int idleTimeout = 10800000;
    private final JvmOptions jvmOptions = new JvmOptions(new IdentityFileResolver());
    private boolean enabled;
    private File javaHome;

    public DaemonParameters(BuildLayoutParameters layout) {
        this(layout, Collections.emptyMap());
    }

    public DaemonParameters(BuildLayoutParameters layout, Map<String, String> extraSystemProperties) {
        this.uid = UUID.randomUUID().toString();
        this.jvmOptions.setAllJvmArgs(DEFAULT_JVM_ARGS);
        this.jvmOptions.systemProperties(extraSystemProperties);
        this.baseDir = new File(layout.getGradleUserHomeDir(), "daemon");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DaemonParameters setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getUid() {
        return this.uid;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public List<String> getEffectiveJvmArgs() {
        return this.jvmOptions.getAllImmutableJvmArgs();
    }

    public List<String> getAllJvmArgs() {
        return this.jvmOptions.getAllJvmArgs();
    }

    public File getEffectiveJavaHome() {
        if (this.javaHome == null) {
            return GFileUtils.canonicalise(Jvm.current().getJavaHome());
        }
        return this.javaHome;
    }

    public String getEffectiveJavaExecutable() {
        if (this.javaHome == null) {
            return Jvm.current().getJavaExecutable().getAbsolutePath();
        }
        return Jvm.forHome(this.javaHome).getJavaExecutable().getAbsolutePath();
    }

    public DaemonParameters setJavaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public Map<String, String> getSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getSystemProperties());
        return systemProperties;
    }

    public Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getSystemProperties());
        GUtil.addToMap(systemProperties, System.getProperties());
        return systemProperties;
    }

    public void setJvmArgs(Iterable<String> jvmArgs) {
        this.jvmOptions.setAllJvmArgs(jvmArgs);
    }

    public void setDebug(boolean debug) {
        this.jvmOptions.setDebug(debug);
    }

    public DaemonParameters setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public boolean getDebug() {
        return this.jvmOptions.getDebug();
    }
}

