/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Properties;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.JvmOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentProcess {
    private final File javaHome;
    private final JvmOptions effectiveJvmOptions;

    public CurrentProcess() {
        this(Jvm.current().getJavaHome(), CurrentProcess.inferJvmOptions());
    }

    public CurrentProcess(File javaHome, JvmOptions effectiveJvmOptions) {
        this.javaHome = javaHome;
        this.effectiveJvmOptions = effectiveJvmOptions;
    }

    public JvmOptions getJvmOptions() {
        return this.effectiveJvmOptions;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean javaHomeMatch = this.getJavaHome().equals(requiredBuildParameters.getEffectiveJavaHome());
        List<String> currentImmutable = new JvmOptions(new IdentityFileResolver()).getAllImmutableJvmArgs();
        List<String> requiredImmutable = requiredBuildParameters.getEffectiveJvmArgs();
        List<String> requiredImmutableMinusDefaults = this.removeDefaults(requiredImmutable);
        boolean noImmutableJvmArgsRequired = requiredImmutableMinusDefaults.equals(currentImmutable);
        if (javaHomeMatch && noImmutableJvmArgsRequired) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }

    private List<String> removeDefaults(List<String> effectiveJvmArgs) {
        return Lists.newArrayList((Iterable)Iterables.filter(effectiveJvmArgs, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !DaemonParameters.DEFAULT_JVM_ARGS.contains(input);
            }
        }));
    }

    private static JvmOptions inferJvmOptions() {
        JvmOptions jvmOptions = new JvmOptions(new IdentityFileResolver());
        jvmOptions.setAllJvmArgs(ManagementFactory.getRuntimeMXBean().getInputArguments());
        return jvmOptions;
    }
}

