/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.ExecHandleBuilder;

public class JvmVersionValidator {
    void validate(DaemonParameters parameters) {
        if (parameters.getEffectiveJavaHome().equals(Jvm.current().getJavaHome())) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecHandleBuilder builder = new ExecHandleBuilder();
        builder.setWorkingDir(new File(".").getAbsolutePath());
        builder.setCommandLine(parameters.getEffectiveJavaExecutable(), "-version");
        builder.setStandardOutput(new ByteArrayOutputStream());
        builder.setErrorOutput(outputStream);
        builder.build().start().waitForFinish().assertNormalExitValue();
        JavaVersion javaVersion = JvmVersionValidator.parseJavaVersionCommandOutput(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outputStream.toByteArray()))));
        if (!javaVersion.isJava6Compatible()) {
            throw UnsupportedJavaRuntimeException.configuredWithUnsupportedVersion("Gradle", JavaVersion.VERSION_1_6, javaVersion);
        }
    }

    static JavaVersion parseJavaVersionCommandOutput(BufferedReader reader) {
        try {
            String versionStr = reader.readLine();
            while (versionStr != null) {
                Matcher matcher = Pattern.compile("java version \"(.+?)\"").matcher(versionStr);
                if (matcher.matches()) {
                    return JavaVersion.toVersion(matcher.group(1));
                }
                versionStr = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new RuntimeException("Could not determine Java version.");
    }
}

