/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.messaging.remote.internal.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClientConnection
implements Connection<Object> {
    private static final Logger LOG = Logging.getLogger(DaemonClientConnection.class);
    private final Connection<Object> connection;
    private final String uid;
    private final StaleAddressDetector staleAddressDetector;
    private boolean hasReceived;

    public DaemonClientConnection(Connection<Object> connection, String uid, StaleAddressDetector staleAddressDetector) {
        this.connection = connection;
        this.uid = uid;
        this.staleAddressDetector = staleAddressDetector;
    }

    public void requestStop() {
        LOG.debug("thread {}: requesting connection stop", Thread.currentThread().getId());
        this.connection.requestStop();
    }

    public String getUid() {
        return this.uid;
    }

    public void dispatch(Object message) throws DaemonConnectionException {
        LOG.debug("thread {}: dispatching {}", Thread.currentThread().getId(), message.getClass());
        try {
            this.connection.dispatch(message);
        }
        catch (Exception e) {
            LOG.debug("Problem dispatching message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress(e)) {
                throw new StaleDaemonAddressException("Could not dispatch a message to the daemon.", e);
            }
            throw new DaemonConnectionException("Could not dispatch a message to the daemon.", e);
        }
    }

    @Nullable
    public Object receive() throws DaemonConnectionException {
        try {
            Object object = this.connection.receive();
            return object;
        }
        catch (Exception e) {
            LOG.debug("Problem receiving message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress(e)) {
                throw new StaleDaemonAddressException("Could not receive a message from the daemon.", e);
            }
            throw new DaemonConnectionException("Could not receive a message from the daemon.", e);
        }
        finally {
            this.hasReceived = true;
        }
    }

    public void stop() {
        LOG.debug("thread {}: connection stop", Thread.currentThread().getId());
        this.connection.stop();
    }

    static interface StaleAddressDetector {
        public boolean maybeStaleAddress(Exception var1);
    }
}

