/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.messaging.remote.internal.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelDispatcher {
    private static final Logger LOGGER = Logging.getLogger(CancelDispatcher.class);
    private final IdGenerator<?> idGenerator;

    public CancelDispatcher(IdGenerator<?> idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void dispatch(Connection<Object> connection, Object toCancelId) {
        Throwable failure = null;
        try {
            connection.dispatch((Object)new Cancel(this.idGenerator.generateId(), toCancelId));
            Result result = (Result)connection.receive();
            if (result instanceof Failure) {
                failure = (Throwable)((Failure)result).getValue();
            }
            connection.dispatch((Object)new Finished());
        }
        catch (Throwable e) {
            failure = e;
        }
        if (failure != null) {
            LOGGER.lifecycle("Unable to cancel daemon build. The daemon may have crashed.");
            LOGGER.debug(String.format("Unable to complete cancel daemon build using %s.", connection), failure);
        }
    }
}

