/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonServices;
import org.gradle.logging.LoggingManagerInternal;

public class ForegroundDaemonAction
implements Runnable {
    private final ServiceRegistry loggingRegistry;
    private final DaemonServerConfiguration configuration;

    public ForegroundDaemonAction(ServiceRegistry loggingRegistry, DaemonServerConfiguration configuration) {
        this.loggingRegistry = loggingRegistry;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LoggingManagerInternal loggingManager = this.loggingRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.start();
        DaemonServices daemonServices = new DaemonServices(this.configuration, this.loggingRegistry, loggingManager);
        Daemon daemon = daemonServices.get(Daemon.class);
        daemon.start();
        try {
            daemonServices.get(DaemonRegistry.class).markIdle(daemon.getAddress());
            daemon.requestStopOnIdleTimeout(this.configuration.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        finally {
            daemon.stop();
        }
    }
}

