/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.File;
import java.io.PrintStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;

public class DaemonStartupCommunication {
    private static final String DELIM = ";:";
    private static final Logger LOGGER = Logging.getLogger(DaemonStartupCommunication.class);

    public void printDaemonStarted(PrintStream target, Long pid, File daemonLog) {
        target.println(this.daemonStartedMessage(pid, daemonLog));
        LOGGER.debug("Completed writing the daemon greeting. Closing streams...");
    }

    String daemonStartedMessage(Long pid, File daemonLog) {
        return DaemonStartupCommunication.daemonGreeting() + DELIM + pid + DELIM + daemonLog;
    }

    public DaemonDiagnostics readDiagnostics(String message) {
        String[] split = message.split(DELIM);
        String pidString = split[1];
        Long pid = pidString.equals("null") ? null : Long.valueOf(pidString);
        File daemonLog = new File(split[2]);
        return new DaemonDiagnostics(daemonLog, pid);
    }

    public boolean containsGreeting(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Unable to detect the daemon greeting because the input message is null!");
        }
        return message.contains(DaemonStartupCommunication.daemonGreeting());
    }

    private static String daemonGreeting() {
        return "Daemon started. About to close the streams. Daemon details: ";
    }
}

