/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.process.ExecResult;

public class DaemonGreeter {
    private final DocumentationRegistry documentationRegistry;

    public DaemonGreeter(DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
    }

    public DaemonDiagnostics parseDaemonOutput(String output, ExecResult result) {
        if (!new DaemonStartupCommunication().containsGreeting(output)) {
            throw new GradleException(this.prepareMessage(output, result));
        }
        String[] lines = output.split("\n");
        String lastLine = lines[lines.length - 1];
        return new DaemonStartupCommunication().readDiagnostics(lastLine);
    }

    private String prepareMessage(String output, ExecResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to start the daemon process.");
        sb.append("\nThis problem might be caused by incorrect configuration of the daemon.");
        sb.append("\nFor example, an unrecognized jvm option is used.");
        sb.append("\nPlease refer to the user guide chapter on the daemon at ");
        sb.append(this.documentationRegistry.getDocumentationFor("gradle_daemon"));
        sb.append("\nPlease read below process output to find out more:");
        sb.append("\n-----------------------\n");
        sb.append(output);
        return sb.toString();
    }
}

