/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.UncheckedIOException;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.launcher.daemon.configuration.GradleProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutToPropertiesConverter {
    public Map<String, String> convert(BuildLayoutParameters layout, Map<String, String> properties) {
        this.configureFromBuildDir(layout.getProjectDir(), layout.getSearchUpwards(), properties);
        this.configureFromGradleUserHome(layout.getGradleUserHomeDir(), properties);
        properties.putAll(System.getProperties());
        return properties;
    }

    private void configureFromGradleUserHome(File gradleUserHomeDir, Map<String, String> result) {
        this.maybeConfigureFrom(new File(gradleUserHomeDir, "gradle.properties"), result);
    }

    private void configureFromBuildDir(File currentDir, boolean searchUpwards, Map<String, String> result) {
        BuildLayoutFactory factory = new BuildLayoutFactory();
        BuildLayout layout = factory.getLayoutFor(currentDir, searchUpwards);
        this.maybeConfigureFrom(new File(layout.getRootDirectory(), "gradle.properties"), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeConfigureFrom(File propertiesFile, Map<String, String> result) {
        if (!propertiesFile.isFile()) {
            return;
        }
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Object key : properties.keySet()) {
            if (!GradleProperties.ALL.contains(key.toString())) continue;
            result.put(key.toString(), properties.get(key).toString());
        }
    }
}

