/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import org.gradle.StartParameter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.DefaultCommandLineConverter;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.nativeplatform.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.cli.CancelDaemonAction;
import org.gradle.launcher.cli.CommandLineAction;
import org.gradle.launcher.cli.RunBuildAction;
import org.gradle.launcher.cli.StopDaemonAction;
import org.gradle.launcher.cli.converter.DaemonCommandLineConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.PropertiesToDaemonParametersConverter;
import org.gradle.launcher.cli.converter.PropertiesToStartParameterConverter;
import org.gradle.launcher.daemon.bootstrap.ForegroundDaemonAction;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientServices;
import org.gradle.launcher.daemon.client.SingleUseDaemonClientServices;
import org.gradle.launcher.daemon.client.StopDaemonClientServices;
import org.gradle.launcher.daemon.configuration.CurrentProcess;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.ForegroundDaemonConfiguration;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildActionsFactory
implements CommandLineAction {
    private static final String FOREGROUND = "foreground";
    private static final String STOP = "stop";
    private static final String CANCEL = "cancel";
    private final ServiceRegistry loggingServices;
    private final LayoutCommandLineConverter layoutConverter;
    private final SystemPropertiesCommandLineConverter propertiesConverter;
    private final LayoutToPropertiesConverter layoutToPropertiesConverter;
    private final PropertiesToStartParameterConverter propertiesToStartParameterConverter;
    private final DefaultCommandLineConverter commandLineConverter;
    private final DaemonCommandLineConverter daemonConverter;
    private final PropertiesToDaemonParametersConverter propertiesToDaemonParametersConverter;

    BuildActionsFactory(ServiceRegistry loggingServices) {
        this(loggingServices, new DefaultCommandLineConverter());
    }

    BuildActionsFactory(ServiceRegistry loggingServices, DefaultCommandLineConverter commandLineConverter, DaemonCommandLineConverter daemonConverter, LayoutCommandLineConverter layoutConverter, SystemPropertiesCommandLineConverter propertiesConverter, LayoutToPropertiesConverter layoutToPropertiesConverter, PropertiesToStartParameterConverter propertiesToStartParameterConverter, PropertiesToDaemonParametersConverter propertiesToDaemonParametersConverter) {
        this.loggingServices = loggingServices;
        this.commandLineConverter = commandLineConverter;
        this.daemonConverter = daemonConverter;
        this.layoutConverter = layoutConverter;
        this.propertiesConverter = propertiesConverter;
        this.layoutToPropertiesConverter = layoutToPropertiesConverter;
        this.propertiesToStartParameterConverter = propertiesToStartParameterConverter;
        this.propertiesToDaemonParametersConverter = propertiesToDaemonParametersConverter;
    }

    private BuildActionsFactory(ServiceRegistry loggingServices, DefaultCommandLineConverter commandLineConverter) {
        this(loggingServices, commandLineConverter, new DaemonCommandLineConverter(), commandLineConverter.getLayoutConverter(), commandLineConverter.getSystemPropertiesConverter(), new LayoutToPropertiesConverter(), new PropertiesToStartParameterConverter(), new PropertiesToDaemonParametersConverter());
    }

    @Override
    public void configureCommandLineParser(CommandLineParser parser) {
        this.commandLineConverter.configure(parser);
        this.daemonConverter.configure(parser);
        parser.option(new String[]{FOREGROUND}).hasDescription("Starts the Gradle daemon in the foreground.").incubating();
        parser.option(new String[]{STOP}).hasDescription("Stops the Gradle daemon if it is running.");
        parser.option(new String[]{CANCEL}).hasArgument().hasDescription("Cancels the build in Gradle daemon if it is running.").incubating();
    }

    @Override
    public Runnable createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
        BuildLayoutParameters layout = new BuildLayoutParameters();
        this.layoutConverter.convert(commandLine, layout);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.layoutToPropertiesConverter.convert(layout, properties);
        this.propertiesConverter.convert(commandLine, properties);
        StartParameter startParameter = new StartParameter();
        this.propertiesToStartParameterConverter.convert(properties, startParameter);
        this.commandLineConverter.convert(commandLine, startParameter);
        DaemonParameters daemonParameters = new DaemonParameters(layout, startParameter.getSystemPropertiesArgs());
        this.propertiesToDaemonParametersConverter.convert(properties, daemonParameters);
        this.daemonConverter.convert(commandLine, daemonParameters);
        if (commandLine.hasOption(STOP)) {
            return this.stopAllDaemons(daemonParameters, this.loggingServices);
        }
        if (commandLine.hasOption(CANCEL)) {
            return this.cancelDaemonBuild(daemonParameters, this.loggingServices, commandLine.option(CANCEL).getValue());
        }
        if (commandLine.hasOption(FOREGROUND)) {
            ForegroundDaemonConfiguration conf = new ForegroundDaemonConfiguration(daemonParameters.getUid(), daemonParameters.getBaseDir(), daemonParameters.getIdleTimeout());
            return new ForegroundDaemonAction(this.loggingServices, conf);
        }
        if (daemonParameters.isEnabled()) {
            return this.runBuildWithDaemon(startParameter, daemonParameters, this.loggingServices);
        }
        if (this.canUseCurrentProcess(daemonParameters)) {
            return this.runBuildInProcess(startParameter, daemonParameters, this.loggingServices);
        }
        return this.runBuildInSingleUseDaemon(startParameter, daemonParameters, this.loggingServices);
    }

    private Runnable stopAllDaemons(DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        StopDaemonClientServices clientServices = new StopDaemonClientServices(loggingServices, daemonParameters, System.in);
        DaemonClient stopClient = clientServices.get(DaemonClient.class);
        return new StopDaemonAction(stopClient);
    }

    private Runnable cancelDaemonBuild(DaemonParameters daemonParameters, ServiceRegistry loggingServices, String cancelledBuildId) {
        StopDaemonClientServices clientServices = new StopDaemonClientServices(loggingServices, daemonParameters, System.in);
        DaemonClient stopClient = clientServices.get(DaemonClient.class);
        return new CancelDaemonAction(stopClient, cancelledBuildId);
    }

    private Runnable runBuildWithDaemon(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        DaemonClientServices clientServices = new DaemonClientServices(loggingServices, daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.daemonBuildAction(startParameter, daemonParameters, client);
    }

    private boolean canUseCurrentProcess(DaemonParameters requiredBuildParameters) {
        CurrentProcess currentProcess = new CurrentProcess();
        return currentProcess.configureForBuild(requiredBuildParameters);
    }

    private Runnable runBuildInProcess(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        ServiceRegistry globalServices = ServiceRegistryBuilder.builder().displayName("Global services").parent(loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider(new GlobalScopeServices(false)).build();
        InProcessBuildActionExecuter executer = new InProcessBuildActionExecuter(globalServices.get(GradleLauncherFactory.class));
        return this.daemonBuildAction(startParameter, daemonParameters, executer);
    }

    private Runnable runBuildInSingleUseDaemon(StartParameter startParameter, DaemonParameters daemonParameters, ServiceRegistry loggingServices) {
        int maxTimeout = 120000;
        if (daemonParameters.getIdleTimeout() > maxTimeout) {
            daemonParameters.setIdleTimeout(maxTimeout);
        }
        SingleUseDaemonClientServices clientServices = new SingleUseDaemonClientServices(loggingServices, daemonParameters, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.daemonBuildAction(startParameter, daemonParameters, client);
    }

    private Runnable daemonBuildAction(StartParameter startParameter, DaemonParameters daemonParameters, BuildActionExecuter<BuildActionParameters> executer) {
        return new RunBuildAction(executer, startParameter, SystemProperties.getCurrentDir(), this.clientMetaData(), this.getBuildStartTime(), daemonParameters.getEffectiveSystemProperties(), System.getenv());
    }

    private long getBuildStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }
}

