/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.model.Finalize;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelAdapter;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.SingleTypeModelPromise;
import org.gradle.model.internal.core.rule.describe.MethodModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRuleInspector {
    private static final Set<Class<? extends Annotation>> TYPE_ANNOTATIONS = ImmutableSet.of(Model.class, Mutate.class, Finalize.class);

    private static String typeAnnotationsDescription() {
        String desc = Joiner.on((String)", ").join(Iterables.transform(TYPE_ANNOTATIONS, (Function)new Function<Class<? extends Annotation>, String>(){

            public String apply(Class<? extends Annotation> input) {
                return input.getName();
            }
        }));
        return "[" + desc + "]";
    }

    private static <T> T toInstance(Class<T> source) {
        try {
            Constructor<T> declaredConstructor = source.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
    }

    private static RuntimeException invalid(Class<?> source, String reason) {
        return new InvalidModelRuleDeclarationException("Type " + source.getName() + " is not a valid model rule source: " + reason);
    }

    private static RuntimeException invalid(String description, Method method, String reason) {
        StringBuilder sb = new StringBuilder();
        new MethodModelRuleDescriptor(method).describeTo(sb);
        sb.append(" is not a valid ").append(description).append(": ").append(reason);
        return new InvalidModelRuleDeclarationException(sb.toString());
    }

    public static void rule(ModelRegistry modelRegistry, Method method, boolean isFinalizer, Factory<?> instance) {
        List<ModelReference<?>> bindings = ModelRuleInspector.references(method);
        ModelReference<?> subject = bindings.get(0);
        List<ModelReference<?>> inputs = bindings.subList(1, bindings.size());
        MethodModelMutator<?> mutator = ModelRuleInspector.toMutator(method, instance, subject, inputs);
        if (isFinalizer) {
            modelRegistry.finalize(mutator);
        } else {
            modelRegistry.mutate(mutator);
        }
    }

    private static <T> MethodModelMutator<T> toMutator(Method method, Factory<?> instance, ModelReference<T> first, List<ModelReference<?>> tail) {
        return new MethodModelMutator<T>(method, first, tail, instance);
    }

    private static List<ModelReference<?>> references(Method method) {
        Type[] types = method.getGenericParameterTypes();
        ImmutableList.Builder inputBindingBuilder = ImmutableList.builder();
        for (int i = 0; i < types.length; ++i) {
            Type paramType = types[i];
            Annotation[] paramAnnotations = method.getParameterAnnotations()[i];
            inputBindingBuilder.add(ModelRuleInspector.reference(paramType, paramAnnotations));
        }
        return inputBindingBuilder.build();
    }

    private static <T> ModelReference<T> reference(Type type, Annotation[] annotations) {
        Path pathAnnotation = (Path)CollectionUtils.findFirst((Object[])annotations, (Spec)new Spec<Annotation>(){

            public boolean isSatisfiedBy(Annotation element) {
                return element.annotationType().equals(Path.class);
            }
        });
        String path = pathAnnotation == null ? null : pathAnnotation.value();
        ModelType<?> cast = ModelType.of(type);
        return ModelReference.of(path == null ? null : ModelPath.path(path), cast);
    }

    public Set<Class<?>> getDeclaredSources(Class<?> container) {
        Class<?>[] declaredClasses = container.getDeclaredClasses();
        if (declaredClasses.length == 0) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder found = ImmutableSet.builder();
        for (Class<?> declaredClass : declaredClasses) {
            if (!declaredClass.isAnnotationPresent(RuleSource.class)) continue;
            found.add(declaredClass);
        }
        return found.build();
    }

    public <T> void inspect(Class<T> source, ModelRegistry modelRegistry) {
        this.validate(source);
        Method[] methods = source.getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Method method : methods) {
            Annotation annotation = this.getTypeAnnotation(method);
            if (annotation == null) continue;
            if (annotation instanceof Model) {
                this.creationMethod(modelRegistry, method, (Model)annotation);
                continue;
            }
            if (annotation instanceof Mutate) {
                this.mutationMethod(modelRegistry, method, false);
                continue;
            }
            if (annotation instanceof Finalize) {
                this.mutationMethod(modelRegistry, method, true);
                continue;
            }
            throw new IllegalStateException("Unhandled rule type annotation: " + annotation);
        }
    }

    private void mutationMethod(ModelRegistry modelRegistry, final Method method, boolean finalize) {
        if (method.getTypeParameters().length > 0) {
            throw ModelRuleInspector.invalid("model rule", method, "cannot have type variables (i.e. cannot be a generic method)");
        }
        ModelRuleInspector.rule(modelRegistry, method, finalize, new Factory<Object>(){

            public Object create() {
                return ModelRuleInspector.toInstance(method.getDeclaringClass());
            }
        });
    }

    private Annotation getTypeAnnotation(Method method) {
        Annotation annotation = null;
        for (Annotation declaredAnnotation : method.getDeclaredAnnotations()) {
            if (!TYPE_ANNOTATIONS.contains(declaredAnnotation.annotationType())) continue;
            if (annotation == null) {
                annotation = declaredAnnotation;
                continue;
            }
            throw ModelRuleInspector.invalid("model rule", method, "can only be annotated with one of " + ModelRuleInspector.typeAnnotationsDescription());
        }
        return annotation;
    }

    private void creationMethod(ModelRegistry modelRegistry, Method method, Model modelAnnotation) {
        String modelName = this.determineModelName(modelAnnotation, method);
        if (method.getTypeParameters().length > 0) {
            throw ModelRuleInspector.invalid("model creation rule", method, "cannot have type variables (i.e. cannot be a generic method)");
        }
        ModelType<?> returnType = ModelType.of(method.getGenericReturnType());
        this.doRegisterCreation(method, returnType, modelName, modelRegistry);
    }

    private <T, R> void doRegisterCreation(Method method, ModelType<R> type, String modelName, ModelRegistry modelRegistry) {
        ModelPath path = ModelPath.path(modelName);
        List<ModelReference<?>> references = ModelRuleInspector.references(method);
        Class<?> clazz = method.getDeclaringClass();
        Class<R> returnTypeClass = type.getRawClass();
        JavaMethod methodWrapper = JavaReflectionUtil.method(clazz, returnTypeClass, (Method)method);
        modelRegistry.create(new MethodModelCreator(type, path, references, method, clazz, methodWrapper));
    }

    private String determineModelName(Model modelAnnotation, Method method) {
        String annotationValue = modelAnnotation.value();
        if (annotationValue == null || annotationValue.isEmpty()) {
            return method.getName();
        }
        return annotationValue;
    }

    public void validate(Class<?> source) throws InvalidModelRuleDeclarationException {
        Field[] fields;
        Class<?> superclass;
        int modifiers = source.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            throw ModelRuleInspector.invalid(source, "must be a class, not an interface");
        }
        if (Modifier.isAbstract(modifiers)) {
            throw ModelRuleInspector.invalid(source, "class cannot be abstract");
        }
        if (source.getEnclosingClass() != null) {
            if (Modifier.isStatic(modifiers)) {
                if (Modifier.isPrivate(modifiers)) {
                    throw ModelRuleInspector.invalid(source, "class cannot be private");
                }
            } else {
                throw ModelRuleInspector.invalid(source, "enclosed classes must be static and non private");
            }
        }
        if (!(superclass = source.getSuperclass()).equals(Object.class)) {
            throw ModelRuleInspector.invalid(source, "cannot have superclass");
        }
        Constructor<?>[] constructors = source.getDeclaredConstructors();
        if (constructors.length > 1) {
            throw ModelRuleInspector.invalid(source, "cannot have more than one constructor");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterTypes().length > 0) {
            throw ModelRuleInspector.invalid(source, "constructor cannot take any arguments");
        }
        for (Field field : fields = source.getDeclaredFields()) {
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            throw ModelRuleInspector.invalid(source, "field " + field.getName() + " is not static final");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodModelMutator<T>
    implements ModelMutator<T> {
        private final MethodModelRuleDescriptor descriptor;
        private final Method bindingMethod;
        private final ModelReference<T> subject;
        private final List<ModelReference<?>> inputs;
        private final Factory<?> instance;

        public MethodModelMutator(Method method, ModelReference<T> subject, List<ModelReference<?>> inputs, Factory<?> instance) {
            this.bindingMethod = method;
            this.subject = subject;
            this.inputs = inputs;
            this.instance = instance;
            this.descriptor = new MethodModelRuleDescriptor(method);
        }

        @Override
        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public ModelReference<T> getSubject() {
            return this.subject;
        }

        @Override
        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void mutate(T object, Inputs inputs) {
            Object[] args = new Object[1 + this.inputs.size()];
            args[0] = object;
            for (int i = 0; i < inputs.size(); ++i) {
                args[i + 1] = inputs.get(i, this.inputs.get(i).getType()).getInstance();
            }
            this.bindingMethod.setAccessible(true);
            try {
                this.bindingMethod.invoke(this.instance.create(), args);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = e.getCause();
                }
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodModelCreator<R, T>
    implements ModelCreator {
        private final ModelType<R> type;
        private final ModelPath path;
        private final ModelPromise promise;
        private List<ModelReference<?>> inputs;
        private final Method method;
        private final Class<T> clazz;
        private final JavaMethod<T, R> methodWrapper;

        public MethodModelCreator(ModelType<R> type, ModelPath path, List<ModelReference<?>> inputs, Method method, Class<T> clazz, JavaMethod<T, R> methodWrapper) {
            this.type = type;
            this.path = path;
            this.inputs = inputs;
            this.promise = new SingleTypeModelPromise(type);
            this.method = method;
            this.clazz = clazz;
            this.methodWrapper = methodWrapper;
        }

        @Override
        public ModelPath getPath() {
            return this.path;
        }

        @Override
        public ModelPromise getPromise() {
            return this.promise;
        }

        @Override
        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        @Override
        public ModelAdapter create(Inputs inputs) {
            R instance = this.invoke(inputs);
            if (instance == null) {
                throw new ModelRuleExecutionException(this.getDescriptor(), "rule returned null");
            }
            return InstanceModelAdapter.of(this.type, instance);
        }

        private R invoke(Inputs inputs) {
            Object instance;
            Object object = instance = Modifier.isStatic(this.method.getModifiers()) ? null : ModelRuleInspector.toInstance(this.clazz);
            if (inputs.size() == 0) {
                return (R)this.methodWrapper.invoke(instance, new Object[0]);
            }
            Object[] args = new Object[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                args[i] = inputs.get(i, this.inputs.get(i).getType()).getInstance();
            }
            return (R)this.methodWrapper.invoke(instance, args);
        }

        @Override
        public ModelRuleDescriptor getDescriptor() {
            return new MethodModelRuleDescriptor(this.method);
        }
    }
}

