/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.gradle.api.UncheckedIOException;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;

public class MethodModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private static final Joiner PARAMS_JOINER = Joiner.on((String)", ");
    private static final Function<Type, String> TYPE_TO_STRING = new Function<Type, String>(){

        public String apply(Type input) {
            return TypeToken.of((Type)input).toString();
        }
    };
    private final Method method;
    private String description;

    public MethodModelRuleDescriptor(Method method) {
        this.method = method;
    }

    public void describeTo(Appendable appendable) {
        try {
            appendable.append(this.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder(this.method.getDeclaringClass().getName());
            sb.append("#");
            sb.append(this.method.getName());
            sb.append("(");
            PARAMS_JOINER.appendTo(sb, Iterables.transform(Arrays.asList(this.method.getGenericParameterTypes()), TYPE_TO_STRING));
            sb.append(")");
            this.description = sb.toString();
        }
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModelRuleDescriptor that = (MethodModelRuleDescriptor)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

