/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.Factory;
import org.gradle.model.collection.NamedItemCollectionBuilder;
import org.gradle.model.entity.internal.NamedEntityInstantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceBackedModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ActionModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedItemCollectionBuilder<T>
implements NamedItemCollectionBuilder<T> {
    private final ModelPath collectionPath;
    private final NamedEntityInstantiator<T> instantiator;
    private final ModelRuleDescriptor sourceDescriptor;
    private final Inputs implicitInputs;
    private final ModelRuleRegistrar ruleRegistrar;

    public DefaultNamedItemCollectionBuilder(ModelPath collectionPath, NamedEntityInstantiator<T> instantiator, ModelRuleDescriptor sourceDescriptor, Inputs implicitInputs, ModelRuleRegistrar ruleRegistrar) {
        this.collectionPath = collectionPath;
        this.instantiator = instantiator;
        this.sourceDescriptor = sourceDescriptor;
        this.implicitInputs = implicitInputs;
        this.ruleRegistrar = ruleRegistrar;
    }

    @Override
    public void create(String name) {
        this.doCreate(name, this.instantiator.getType(), Actions.doNothing(), new DefaultTypeFactory(name));
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.doCreate(name, this.instantiator.getType(), configAction, new DefaultTypeFactory(name));
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.doCreate(name, ModelType.of(type), Actions.doNothing(), new CustomTypeFactory<S>(name, type));
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.doCreate(name, ModelType.of(type), configAction, new CustomTypeFactory<S>(name, type));
    }

    private <S extends T> void doCreate(final String name, ModelType<S> type, Action<? super S> configAction, Factory<? extends S> factory) {
        ModelPath path = this.collectionPath.child(name);
        NestedModelRuleDescriptor descriptor = new NestedModelRuleDescriptor(this.sourceDescriptor, ActionModelRuleDescriptor.from((Action<? super Appendable>)new ErroringAction<Appendable>(){

            protected void doExecute(Appendable thing) throws Exception {
                thing.append("create(").append(name).append(")");
            }
        }));
        this.ruleRegistrar.create(InstanceBackedModelCreator.of(ModelReference.of(path, type), descriptor, this.implicitInputs.getReferences(), new CreateAndConfigureFactory(factory, configAction)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateAndConfigureFactory<T>
    implements Factory<T> {
        private final Factory<? extends T> factory;
        private final Action<? super T> action;

        private CreateAndConfigureFactory(Factory<? extends T> factory, Action<? super T> action) {
            this.factory = factory;
            this.action = action;
        }

        public T create() {
            Object t = this.factory.create();
            this.action.execute(t);
            return (T)t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTypeFactory
    implements Factory<T> {
        private final String name;

        public DefaultTypeFactory(String name) {
            this.name = name;
        }

        public T create() {
            return DefaultNamedItemCollectionBuilder.this.instantiator.create(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomTypeFactory<S extends T>
    implements Factory<S> {
        private final String name;
        private final Class<S> type;

        public CustomTypeFactory(String name, Class<S> type) {
            this.name = name;
            this.type = type;
        }

        public S create() {
            return DefaultNamedItemCollectionBuilder.this.instantiator.create(this.name, this.type);
        }
    }
}

