/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry;

import org.gradle.api.plugins.buildcomparison.compare.internal.ComparisonResultType;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;

public class ArchiveEntryComparison {
    private final String path;
    private final ArchiveEntry source;
    private final ArchiveEntry target;

    public ArchiveEntryComparison(String path, ArchiveEntry source, ArchiveEntry target) {
        if (source == null && target == null) {
            throw new IllegalArgumentException("Both 'from' and 'to' cannot be null");
        }
        this.path = path;
        this.source = source;
        this.target = target;
    }

    public ComparisonResultType getComparisonResultType() {
        if (this.source != null && this.target == null) {
            return ComparisonResultType.SOURCE_ONLY;
        }
        if (this.source == null && this.target != null) {
            return ComparisonResultType.TARGET_ONLY;
        }
        return this.source.equals(this.target) ? ComparisonResultType.EQUAL : ComparisonResultType.UNEQUAL;
    }

    public String getPath() {
        return this.path;
    }

    public ArchiveEntry getSource() {
        return this.source;
    }

    public ArchiveEntry getTarget() {
        return this.target;
    }
}

