/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociation;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcomeComparisonResult;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntryComparison;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.FileToArchiveEntrySetTransformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ZipEntryToArchiveEntryTransformer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedArchiveBuildOutcomeComparator
implements BuildOutcomeComparator<GeneratedArchiveBuildOutcome, GeneratedArchiveBuildOutcomeComparisonResult> {
    private final Transformer<Set<ArchiveEntry>, File> archiveToEntriesTransformer;

    public GeneratedArchiveBuildOutcomeComparator() {
        this(new FileToArchiveEntrySetTransformer(new ZipEntryToArchiveEntryTransformer()));
    }

    GeneratedArchiveBuildOutcomeComparator(Transformer<Set<ArchiveEntry>, File> archiveToEntriesTransformer) {
        this.archiveToEntriesTransformer = archiveToEntriesTransformer;
    }

    @Override
    public Class<GeneratedArchiveBuildOutcome> getComparedType() {
        return GeneratedArchiveBuildOutcome.class;
    }

    @Override
    public GeneratedArchiveBuildOutcomeComparisonResult compare(BuildOutcomeAssociation<GeneratedArchiveBuildOutcome> association) {
        GeneratedArchiveBuildOutcome source = association.getSource();
        GeneratedArchiveBuildOutcome target = association.getTarget();
        Set sourceEntries = source.getArchiveFile() != null && source.getArchiveFile().exists() ? (Set)this.archiveToEntriesTransformer.transform((Object)source.getArchiveFile()) : Collections.emptySet();
        Set targetEntries = target.getArchiveFile() != null && target.getArchiveFile().exists() ? (Set)this.archiveToEntriesTransformer.transform((Object)target.getArchiveFile()) : Collections.emptySet();
        CollectionUtils.SetDiff diff = CollectionUtils.diffSetsBy((Set)sourceEntries, targetEntries, (Transformer)new Transformer<String, ArchiveEntry>(){

            public String transform(ArchiveEntry entry) {
                return entry.getPath();
            }
        });
        TreeSet<ArchiveEntryComparison> entryComparisons = new TreeSet<ArchiveEntryComparison>(new Comparator<ArchiveEntryComparison>(){

            @Override
            public int compare(ArchiveEntryComparison o1, ArchiveEntryComparison o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        for (ArchiveEntry sourceOnly : diff.leftOnly) {
            entryComparisons.add(new ArchiveEntryComparison(sourceOnly.getPath(), sourceOnly, null));
        }
        for (CollectionUtils.SetDiff.Pair pair : diff.common) {
            entryComparisons.add(new ArchiveEntryComparison(((ArchiveEntry)pair.left).getPath(), (ArchiveEntry)pair.left, (ArchiveEntry)pair.right));
        }
        for (ArchiveEntry targetOnly : diff.rightOnly) {
            entryComparisons.add(new ArchiveEntryComparison(targetOnly.getPath(), null, targetOnly));
        }
        return new GeneratedArchiveBuildOutcomeComparisonResult(association, entryComparisons);
    }
}

