/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeMatcher;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.LegacyPluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.service.internal.ErrorResponse;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResolutionServiceResolver
implements PluginResolver {
    public static final String OVERRIDE_URL_PROPERTY = PluginResolutionServiceResolver.class.getName() + ".repo.override";
    private static final String DEFAULT_API_URL = "https://plugins.gradle.org/api/gradle";
    private static final VersionMatcher RANGE_MATCHER = new VersionRangeMatcher(null);
    private static final VersionMatcher SUB_MATCHER = new SubVersionMatcher(null);
    private static final VersionMatcher LATEST_MATCHER = new LatestVersionMatcher();
    private final PluginResolutionServiceClient portalClient;
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final Factory<DependencyResolutionServices> dependencyResolutionServicesFactory;
    private final ClassLoaderScope parentScope;

    public PluginResolutionServiceResolver(PluginResolutionServiceClient portalClient, Instantiator instantiator, StartParameter startParameter, ClassLoaderScope parentScope, Factory<DependencyResolutionServices> dependencyResolutionServicesFactory) {
        this.portalClient = portalClient;
        this.instantiator = instantiator;
        this.startParameter = startParameter;
        this.parentScope = parentScope;
        this.dependencyResolutionServicesFactory = dependencyResolutionServicesFactory;
    }

    private static String getUrl() {
        return System.getProperty(OVERRIDE_URL_PROPERTY, DEFAULT_API_URL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resolve(PluginRequest pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        if (pluginRequest.getVersion() == null) {
            result.notFound(this.getDescription(), "plugin dependency must include a version number for this source");
            return;
        } else if (pluginRequest.getVersion().endsWith("-SNAPSHOT")) {
            result.notFound(this.getDescription(), "snapshot plugin versions are not supported");
            return;
        } else if (this.isDynamicVersion(pluginRequest.getVersion())) {
            result.notFound(this.getDescription(), "dynamic plugin versions are not supported");
            return;
        } else {
            PluginResolutionServiceClient.Response<PluginUseMetaData> response = this.portalClient.queryPluginMetadata(PluginResolutionServiceResolver.getUrl(), this.startParameter.isRefreshDependencies(), pluginRequest);
            if (response.isError()) {
                ErrorResponse errorResponse = response.getErrorResponse();
                if (response.getStatusCode() != 404) throw new GradleException(String.format("Plugin resolution service returned HTTP %d with message '%s' (url: %s)", response.getStatusCode(), errorResponse.message, response.getUrl()));
                result.notFound(this.getDescription(), errorResponse.message);
                return;
            } else {
                PluginUseMetaData metaData = response.getResponse();
                if (metaData.legacy) {
                    this.handleLegacy(metaData, result);
                    return;
                } else {
                    ClassPath classPath = this.resolvePluginDependencies(metaData);
                    ClassPathPluginResolution resolution = new ClassPathPluginResolution(this.instantiator, pluginRequest.getId(), this.parentScope, (Factory<? extends ClassPath>)Factories.constant((Object)classPath));
                    result.found(this.getDescription(), resolution);
                }
            }
        }
    }

    private void handleLegacy(final PluginUseMetaData metadata, PluginResolutionResult result) {
        result.foundLegacy(this.getDescription(), (Action<? super LegacyPluginResolveContext>)new Action<LegacyPluginResolveContext>(){

            public void execute(LegacyPluginResolveContext context) {
                context.add(metadata.id, metadata.implementation.get("repo"), metadata.implementation.get("gav"));
            }
        });
    }

    private boolean isDynamicVersion(String version) {
        return RANGE_MATCHER.canHandle(version) || SUB_MATCHER.canHandle(version) || LATEST_MATCHER.canHandle(version);
    }

    private ClassPath resolvePluginDependencies(PluginUseMetaData metadata) {
        DependencyResolutionServices resolution = (DependencyResolutionServices)this.dependencyResolutionServicesFactory.create();
        RepositoryHandler repositories = resolution.getResolveRepositoryHandler();
        final String repoUrl = metadata.implementation.get("repo");
        repositories.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)repoUrl);
            }
        });
        Dependency dependency = resolution.getDependencyHandler().create((Object)metadata.implementation.get("gav"));
        ConfigurationContainerInternal configurations = resolution.getConfigurationContainer();
        ConfigurationInternal configuration = configurations.detachedConfiguration(new Dependency[]{dependency});
        StartParameterResolutionOverride resolutionOverride = new StartParameterResolutionOverride(this.startParameter);
        resolutionOverride.addResolutionRules(configuration.getResolutionStrategy().getResolutionRules());
        try {
            Set files = configuration.getResolvedConfiguration().getFiles(Specs.satisfyAll());
            return new DefaultClassPath((Iterable)files);
        }
        catch (ResolveException e) {
            throw new DependencyResolutionException("Failed to resolve all plugin dependencies from " + repoUrl, e.getCause());
        }
    }

    public String getDescription() {
        return "Gradle Central Plugin Repository";
    }

    @Contextual
    public static class DependencyResolutionException
    extends GradleException {
        public DependencyResolutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

