/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.SimplePluginResolution;

public class CorePluginResolver
implements PluginResolver {
    public static final String CORE_PLUGIN_NAMESPACE = "org.gradle";
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public CorePluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    public void resolve(PluginRequest pluginRequest, PluginResolutionResult result) {
        PluginId id = pluginRequest.getId();
        if (!id.isQualified() || id.inNamespace(CORE_PLUGIN_NAMESPACE)) {
            try {
                Class typeForId = this.pluginRegistry.getTypeForId(id.getName());
                if (pluginRequest.getVersion() != null) {
                    throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + id + "' is a core Gradle plugin, which cannot be specified with a version number. " + "Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
                }
                result.found(CorePluginResolver.getDescription(), new SimplePluginResolution(id, typeForId));
            }
            catch (UnknownPluginException e) {
                result.notFound(CorePluginResolver.getDescription(), String.format("not a core plugin, please see %s for available core plugins", this.documentationRegistry.getDocumentationFor("standard_plugins")));
            }
        } else {
            result.notFound(CorePluginResolver.getDescription(), String.format("plugin is not in '%s' namespace", CORE_PLUGIN_NAMESPACE));
        }
    }

    public static String getDescription() {
        return "Gradle Core Plugins";
    }
}

