/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.PluginAware;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginResolutionApplicator;
import org.gradle.plugin.use.resolve.internal.LegacyPluginResolveContext;
import org.gradle.plugin.use.resolve.internal.NotNonCorePluginOnClasspathCheckPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private final PluginRegistry pluginRegistry;
    private final PluginResolver pluginResolver;

    public DefaultPluginRequestApplicator(PluginRegistry pluginRegistry, PluginResolver pluginResolver) {
        this.pluginRegistry = pluginRegistry;
        this.pluginResolver = pluginResolver;
    }

    public void applyPlugins(Iterable<? extends PluginRequest> requests, ScriptHandler scriptHandler, final PluginAware target, ClassLoaderScope classLoaderScope) {
        Configuration classpathConfiguration;
        Set files;
        final PluginResolutionApplicator resolutionApplicator = new PluginResolutionApplicator(target);
        final PluginResolver effectivePluginResolver = this.wrapInNotInClasspathCheck(classLoaderScope);
        List results = CollectionUtils.collect(requests, (Transformer)new Transformer<Result, PluginRequest>(){

            public Result transform(PluginRequest request) {
                return DefaultPluginRequestApplicator.this.resolveToFoundResult(effectivePluginResolver, request);
            }
        });
        ImmutableListMultimap categorizedResults = CollectionUtils.groupBy((Iterable)results, (Transformer)new Transformer<Boolean, Result>(){

            public Boolean transform(Result original) {
                return original.legacyFound != null;
            }
        });
        ImmutableList legacy = categorizedResults.get((Object)true);
        ImmutableList nonLegacy = categorizedResults.get((Object)false);
        final LinkedHashMap legacyActualPluginIds = Maps.newLinkedHashMap();
        if (!legacy.isEmpty()) {
            RepositoryHandler repositories = scriptHandler.getRepositories();
            NamedDomainObjectList mavenRepos = repositories.withType(MavenArtifactRepository.class);
            for (final Result result : legacy) {
                result.legacyFound.action.execute((Object)new LegacyPluginResolveContext((List)mavenRepos, repositories, scriptHandler){
                    final /* synthetic */ List val$mavenRepos;
                    final /* synthetic */ RepositoryHandler val$repositories;
                    final /* synthetic */ ScriptHandler val$scriptHandler;
                    {
                        this.val$mavenRepos = list;
                        this.val$repositories = repositoryHandler;
                        this.val$scriptHandler = scriptHandler;
                    }

                    public Dependency add(String pluginId, final String m2RepoUrl, Object dependencyNotation) {
                        legacyActualPluginIds.put(result, pluginId);
                        boolean repoExists = CollectionUtils.any((Iterable)this.val$mavenRepos, (Spec)new Spec<MavenArtifactRepository>(){

                            public boolean isSatisfiedBy(MavenArtifactRepository element) {
                                return element.getUrl().toString().equals(m2RepoUrl);
                            }
                        });
                        if (!repoExists) {
                            this.val$repositories.maven((Action)new Action<MavenArtifactRepository>(){

                                public void execute(MavenArtifactRepository mavenArtifactRepository) {
                                    mavenArtifactRepository.setUrl((Object)m2RepoUrl);
                                }
                            });
                        }
                        return this.val$scriptHandler.getDependencies().add("classpath", dependencyNotation);
                    }
                });
            }
        }
        if (!(files = (classpathConfiguration = scriptHandler.getConfigurations().getByName("classpath")).getFiles()).isEmpty()) {
            DefaultClassPath classPath = new DefaultClassPath((Iterable)files);
            Factory factory = classLoaderScope.getParent().loader((ClassPath)classPath);
            classLoaderScope.export(factory);
        }
        classLoaderScope.lock();
        for (Map.Entry entry : legacyActualPluginIds.entrySet()) {
            PluginRequest request = ((Result)entry.getKey()).request;
            final String id = (String)entry.getValue();
            this.applyPlugin(request, id, new Runnable(){

                public void run() {
                    target.getPlugins().apply(id);
                }
            });
        }
        for (final Result result : nonLegacy) {
            this.applyPlugin(result.request, result.found.resolution.getPluginId().toString(), new Runnable(){

                public void run() {
                    resolutionApplicator.execute(result.found.resolution);
                }
            });
        }
    }

    private PluginResolver wrapInNotInClasspathCheck(ClassLoaderScope classLoaderScope) {
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(classLoaderScope.getParent().getExportClassLoader());
        return new NotNonCorePluginOnClasspathCheckPluginResolver(this.pluginResolver, this.pluginRegistry, (PluginDescriptorLocator)scriptClasspathPluginDescriptorLocator);
    }

    private void applyPlugin(PluginRequest request, String id, Runnable applicator) {
        try {
            try {
                applicator.run();
            }
            catch (UnknownPluginException e) {
                throw new InvalidPluginException(String.format("Could not apply requested plugin %s as it does not provide a plugin with id '%s'. This is caused by an incorrect plugin implementation. Please contact the plugin author(s).", request, id), (Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidPluginException(String.format("An exception occurred applying plugin request %s", request), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)e, request.getScriptSource(), Integer.valueOf(request.getLineNumber()));
        }
    }

    private Result resolveToFoundResult(PluginResolver effectivePluginResolver, PluginRequest request) {
        Result result = new Result(request);
        try {
            effectivePluginResolver.resolve(request, result);
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s", request.getDisplayName()), (Throwable)e), request.getScriptSource(), Integer.valueOf(request.getLineNumber()));
        }
        if (!result.isFound()) {
            String message = this.buildNotFoundMessage(request, result);
            UnknownPluginException exception = new UnknownPluginException(message);
            throw new LocationAwareException((Throwable)exception, request.getScriptSource(), Integer.valueOf(request.getLineNumber()));
        }
        return result;
    }

    private String buildNotFoundMessage(PluginRequest pluginRequest, Result result) {
        if (result.notFoundList.isEmpty()) {
            return String.format("Plugin %s was not found", pluginRequest.getDisplayName());
        }
        StringBuilder sb = new StringBuilder("Plugin ").append(pluginRequest.getDisplayName()).append(" was not found in any of the following sources:\n");
        for (NotFound notFound : result.notFoundList) {
            sb.append('\n').append("- ").append(notFound.source);
            if (notFound.detail == null) continue;
            sb.append(" (").append(notFound.detail).append(")");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Result
    implements PluginResolutionResult {
        private final List<NotFound> notFoundList = new LinkedList<NotFound>();
        private final PluginRequest request;
        private Found found;
        private LegacyFound legacyFound;

        public Result(PluginRequest request) {
            this.request = request;
        }

        @Override
        public void notFound(String sourceDescription, String notFoundDetail) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundDetail));
        }

        @Override
        public void found(String sourceDescription, PluginResolution pluginResolution) {
            this.found = new Found(sourceDescription, pluginResolution);
        }

        @Override
        public void foundLegacy(String sourceDescription, Action<? super LegacyPluginResolveContext> action) {
            this.legacyFound = new LegacyFound(sourceDescription, action);
        }

        @Override
        public boolean isFound() {
            return this.found != null || this.legacyFound != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LegacyFound {
        private final String source;
        private final Action<? super LegacyPluginResolveContext> action;

        private LegacyFound(String source, Action<? super LegacyPluginResolveContext> action) {
            this.source = source;
            this.action = action;
        }
    }

    private static class Found {
        private final String source;
        private final PluginResolution resolution;

        private Found(String source, PluginResolution resolution) {
            this.source = source;
            this.resolution = resolution;
        }
    }

    private static class NotFound {
        private final String source;
        private final String detail;

        private NotFound(String source, String detail) {
            this.source = source;
            this.detail = detail;
        }
    }
}

