/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.model.dsl.ModelDsl;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyModelDsl
extends GroovyObjectSupport
implements ModelDsl {
    private final ModelPath modelPath;
    private final ModelRegistry modelRegistry;
    private AtomicBoolean executingDsl;

    public GroovyModelDsl(ModelRegistry modelRegistry) {
        this(new AtomicBoolean(), null, modelRegistry);
    }

    private GroovyModelDsl(AtomicBoolean executingDsl, ModelPath modelPath, ModelRegistry modelRegistry) {
        this.executingDsl = executingDsl;
        this.modelPath = modelPath;
        this.modelRegistry = modelRegistry;
    }

    private GroovyModelDsl getChildPath(String name) {
        ModelPath path = this.modelPath == null ? ModelPath.path((String)name) : this.modelPath.child(name);
        return new GroovyModelDsl(this.executingDsl, path, this.modelRegistry);
    }

    private void registerConfigurationAction(final Closure<?> action) {
        this.modelRegistry.mutate((ModelMutator)new ModelMutator<Object>(){

            public ModelReference<Object> getSubject() {
                return ModelReference.untyped((ModelPath)GroovyModelDsl.this.modelPath);
            }

            public void mutate(Object object, Inputs inputs) {
                new ClosureBackedAction(action).execute(object);
            }

            public ModelRuleDescriptor getDescriptor() {
                return new SimpleModelRuleDescriptor("model." + GroovyModelDsl.this.modelPath);
            }

            public List<ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Closure<?> action) {
        this.executingDsl.set(true);
        try {
            new ClosureBackedAction(action).execute((Object)this);
        }
        finally {
            this.executingDsl.set(false);
        }
    }

    public GroovyModelDsl propertyMissing(String name) {
        if (!this.executingDsl.get()) {
            throw new MissingPropertyException(name, this.getClass());
        }
        return this.getChildPath(name);
    }

    public Void methodMissing(String name, Object argsObj) {
        Object[] args = (Object[])argsObj;
        if (!this.executingDsl.get() || args.length != 1 || !(args[0] instanceof Closure)) {
            throw new MissingMethodException(name, this.getClass(), args);
        }
        Closure closure = (Closure)args[0];
        this.getChildPath(name).registerConfigurationAction(closure);
        return null;
    }
}

