/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSettings
extends AbstractPluginAware
implements SettingsInternal {
    public static final String DEFAULT_BUILD_SRC_DIR = "buildSrc";
    private ScriptSource settingsScript;
    private StartParameter startParameter;
    private File settingsDir;
    private DefaultProjectDescriptor rootProjectDescriptor;
    private ProjectDescriptor defaultProjectDescriptor;
    private GradleInternal gradle;
    private ProjectDescriptorRegistry projectDescriptorRegistry;
    private PluginContainer plugins;
    private FileResolver fileResolver;
    private final ScriptPluginFactory scriptPluginFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final ClassLoaderScope classLoaderScope;

    public BaseSettings(ServiceRegistryFactory serviceRegistryFactory, GradleInternal gradle, ClassLoaderScope classLoaderScope, File settingsDir, ScriptSource settingsScript, StartParameter startParameter) {
        this.gradle = gradle;
        this.settingsDir = settingsDir;
        this.settingsScript = settingsScript;
        this.startParameter = startParameter;
        this.classLoaderScope = classLoaderScope;
        ServiceRegistry services = serviceRegistryFactory.createFor(this);
        this.plugins = (PluginContainer)services.get(PluginContainer.class);
        this.fileResolver = (FileResolver)services.get(FileResolver.class);
        this.scriptPluginFactory = (ScriptPluginFactory)services.get(ScriptPluginFactory.class);
        this.scriptHandlerFactory = (ScriptHandlerFactory)services.get(ScriptHandlerFactory.class);
        this.projectDescriptorRegistry = (ProjectDescriptorRegistry)services.get(ProjectDescriptorRegistry.class);
        this.rootProjectDescriptor = this.createProjectDescriptor(null, settingsDir.getName(), settingsDir);
    }

    public String toString() {
        return String.format("settings '%s'", this.rootProjectDescriptor.getName());
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public Settings getSettings() {
        return this;
    }

    public DefaultProjectDescriptor createProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir) {
        return new DefaultProjectDescriptor(parent, name, dir, this.projectDescriptorRegistry, this.fileResolver);
    }

    @Override
    public DefaultProjectDescriptor findProject(String path) {
        return (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(path);
    }

    @Override
    public DefaultProjectDescriptor findProject(File projectDir) {
        return (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(projectDir);
    }

    @Override
    public DefaultProjectDescriptor project(String path) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(path);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", path));
        }
        return projectDescriptor;
    }

    @Override
    public DefaultProjectDescriptor project(File projectDir) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(projectDir);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", projectDir));
        }
        return projectDescriptor;
    }

    @Override
    public void include(String[] projectPaths) {
        for (String projectPath : projectPaths) {
            String subPath = "";
            String[] pathElements = this.removeTrailingColon(projectPath).split(":");
            DefaultProjectDescriptor parentProjectDescriptor = this.rootProjectDescriptor;
            for (String pathElement : pathElements) {
                DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(subPath = subPath + ":" + pathElement);
                parentProjectDescriptor = projectDescriptor == null ? this.createProjectDescriptor(parentProjectDescriptor, pathElement, new File(parentProjectDescriptor.getProjectDir(), pathElement)) : projectDescriptor;
            }
        }
    }

    @Override
    public void includeFlat(String[] projectNames) {
        for (String projectName : projectNames) {
            this.createProjectDescriptor(this.rootProjectDescriptor, projectName, new File(this.rootProjectDescriptor.getProjectDir().getParentFile(), projectName));
        }
    }

    private String removeTrailingColon(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    @Override
    public ProjectDescriptor getRootProject() {
        return this.rootProjectDescriptor;
    }

    public void setRootProjectDescriptor(DefaultProjectDescriptor rootProjectDescriptor) {
        this.rootProjectDescriptor = rootProjectDescriptor;
    }

    @Override
    public ProjectDescriptor getDefaultProject() {
        return this.defaultProjectDescriptor;
    }

    @Override
    public void setDefaultProject(ProjectDescriptor defaultProjectDescriptor) {
        this.defaultProjectDescriptor = defaultProjectDescriptor;
    }

    @Override
    public File getRootDir() {
        return this.rootProjectDescriptor.getProjectDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public File getSettingsDir() {
        return this.settingsDir;
    }

    public void setSettingsDir(File settingsDir) {
        this.settingsDir = settingsDir;
    }

    @Override
    public ScriptSource getSettingsScript() {
        return this.settingsScript;
    }

    public void setSettingsScript(ScriptSource settingsScript) {
        this.settingsScript = settingsScript;
    }

    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(ProjectDescriptorRegistry projectDescriptorRegistry) {
        this.projectDescriptorRegistry = projectDescriptorRegistry;
    }

    @Override
    public ProjectRegistry<DefaultProjectDescriptor> getProjectRegistry() {
        return this.projectDescriptorRegistry;
    }

    @Override
    public PluginContainer getPlugins() {
        return this.plugins;
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.fileResolver, this.scriptPluginFactory, this.scriptHandlerFactory, this.getClassLoaderScope(), this);
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }
}

