/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.EmptyFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDependenciesOnlyFileCollectionResolveContext
extends DefaultFileCollectionResolveContext {
    public BuildDependenciesOnlyFileCollectionResolveContext() {
        super(new IdentityFileResolver(), new BuildableFileTreeInternalConverter(), new BuildableFileTreeInternalConverter());
    }

    public List<? extends Buildable> resolveAsBuildables() {
        return this.resolveAsFileCollections();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildableFileTreeInternalConverter
    implements DefaultFileCollectionResolveContext.Converter<FileTree> {
        private BuildableFileTreeInternalConverter() {
        }

        @Override
        public void convertInto(Object element, Collection<? super FileTree> result, FileResolver resolver) {
            if (element instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext nestedContext = (DefaultFileCollectionResolveContext)element;
                result.addAll(nestedContext.resolveAsFileTrees());
            } else if (element instanceof Buildable) {
                Buildable buildable = (Buildable)element;
                result.add(new FileTreeAdapter(new EmptyFileTree(buildable.getBuildDependencies())));
            } else if (element instanceof TaskDependency) {
                TaskDependency dependency = (TaskDependency)element;
                result.add(new FileTreeAdapter(new EmptyFileTree(dependency)));
            }
        }
    }
}

