/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

public class DefaultClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;

    public DefaultClassPathProvider(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_RUNTIME")) {
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            for (Module module : this.moduleRegistry.getModule("gradle-launcher").getAllRequiredModules()) {
                classpath = classpath.plus(module.getClasspath());
            }
            return classpath;
        }
        if (name.equals("GRADLE_CORE")) {
            return this.moduleRegistry.getModule("gradle-core").getImplementationClasspath();
        }
        if (name.equals("COMMONS_CLI")) {
            return this.moduleRegistry.getExternalModule("commons-cli").getClasspath();
        }
        if (name.equals("ANT")) {
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("ant").getClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("ant-launcher").getClasspath());
            return classpath;
        }
        if (name.equals("GROOVY")) {
            return this.moduleRegistry.getExternalModule("groovy-all").getClasspath();
        }
        return null;
    }
}

