/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.project;

import java.io.File;
import java.util.List;
import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.artifact.handler.ArtifactHandler;
import org.gradle.mvn3.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.gradle.mvn3.org.apache.maven.model.Resource;
import org.gradle.mvn3.org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.apache.maven.project.MavenProjectHelper;
import org.gradle.mvn3.org.apache.maven.project.artifact.AttachedArtifact;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=MavenProjectHelper.class)
public class DefaultMavenProjectHelper
extends AbstractLogEnabled
implements MavenProjectHelper {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    public void attachArtifact(MavenProject project, String artifactType, String artifactClassifier, File artifactFile) {
        String type = artifactType;
        ArtifactHandler handler = null;
        if (type != null) {
            handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler == null) {
            handler = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, artifactClassifier, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, String artifactType, File artifactFile) {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, File artifactFile, String artifactClassifier) {
        Artifact projectArtifact = project.getArtifact();
        AttachedArtifact artifact = new AttachedArtifact(projectArtifact, projectArtifact.getType(), artifactClassifier, projectArtifact.getArtifactHandler());
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, Artifact artifact) {
        try {
            project.addAttachedArtifact(artifact);
        }
        catch (DuplicateArtifactAttachmentException dae) {
            this.getLogger().warn(dae.getMessage());
            throw dae;
        }
    }

    public void addResource(MavenProject project, String resourceDirectory, List includes, List excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addResource(resource);
    }

    public void addTestResource(MavenProject project, String resourceDirectory, List includes, List excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addTestResource(resource);
    }
}

