/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.artifact.ArtifactUtils;
import org.gradle.mvn3.org.apache.maven.execution.BuildSuccess;
import org.gradle.mvn3.org.apache.maven.execution.ExecutionEvent;
import org.gradle.mvn3.org.apache.maven.execution.MavenExecutionRequest;
import org.gradle.mvn3.org.apache.maven.execution.MavenSession;
import org.gradle.mvn3.org.apache.maven.lifecycle.LifecycleExecutionException;
import org.gradle.mvn3.org.apache.maven.lifecycle.MavenExecutionPlan;
import org.gradle.mvn3.org.apache.maven.lifecycle.Schedule;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.BuildLogItem;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.BuilderCommon;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ConcurrentBuildLogger;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.CurrentPhaseForThread;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.DependencyContext;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.MojoExecutor;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ProjectSegment;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ReactorContext;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.TaskSegment;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ThreadLockedArtifact;
import org.gradle.mvn3.org.apache.maven.model.Plugin;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleWeaveBuilder.class)
public class LifecycleWeaveBuilder {
    @Requirement
    private MojoExecutor mojoExecutor;
    @Requirement
    private BuilderCommon builderCommon;
    @Requirement
    private Logger logger;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    private Map<MavenProject, MavenExecutionPlan> executionPlans = new HashMap<MavenProject, MavenExecutionPlan>();

    public LifecycleWeaveBuilder() {
    }

    public LifecycleWeaveBuilder(MojoExecutor mojoExecutor, BuilderCommon builderCommon, Logger logger, ExecutionEventCatapult eventCatapult) {
        this.mojoExecutor = mojoExecutor;
        this.builderCommon = builderCommon;
        this.logger = logger;
        this.eventCatapult = eventCatapult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(ProjectBuildList projectBuilds, ReactorContext buildContext, List<TaskSegment> taskSegments, MavenSession session, ExecutorService executor, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        ConcurrentBuildLogger concurrentBuildLogger = new ConcurrentBuildLogger();
        ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
        try {
            for (MavenProject mavenProject : session.getProjects()) {
                Artifact mainArtifact = mavenProject.getArtifact();
                if (mainArtifact == null || mainArtifact instanceof ThreadLockedArtifact) continue;
                ThreadLockedArtifact threadLockedArtifact = new ThreadLockedArtifact(mainArtifact);
                mavenProject.setArtifact(threadLockedArtifact);
            }
            ArrayList<Future<ProjectSegment>> futures = new ArrayList<Future<ProjectSegment>>();
            HashMap<ProjectSegment, Future<MavenExecutionPlan>> plans = new HashMap<ProjectSegment, Future<MavenExecutionPlan>>();
            for (TaskSegment taskSegment : taskSegments) {
                ProjectBuildList segmentChunks = projectBuilds.getByTaskSegment(taskSegment);
                HashSet<Artifact> projectArtifacts = new HashSet<Artifact>();
                for (ProjectSegment projectSegment : segmentChunks) {
                    Artifact artifact = projectSegment.getProject().getArtifact();
                    if (artifact == null) continue;
                    projectArtifacts.add(artifact);
                }
                for (ProjectSegment projectSegment : segmentChunks) {
                    plans.put(projectSegment, executor.submit(this.createEPFuture(projectSegment, projectArtifacts)));
                }
                for (ProjectSegment projectSegment : plans.keySet()) {
                    this.executionPlans.put(projectSegment.getProject(), (MavenExecutionPlan)((Future)plans.get(projectSegment)).get());
                }
                for (ProjectSegment projectSegment : segmentChunks) {
                    try {
                        MavenExecutionPlan executionPlan = (MavenExecutionPlan)((Future)plans.get(projectSegment)).get();
                        DependencyContext dependencyContext = this.mojoExecutor.newDependencyContext(session, executionPlan.getMojoExecutions());
                        Callable<ProjectSegment> projectBuilder = this.createCallableForBuildingOneFullModule(buildContext, session, reactorBuildStatus, executionPlan, projectSegment, dependencyContext, concurrentBuildLogger);
                        futures.add(service.submit(projectBuilder));
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e);
                    }
                }
                for (Future future : futures) {
                    future.get();
                }
                futures.clear();
            }
        }
        finally {
            projectBuilds.closeAll();
        }
        this.logger.info(concurrentBuildLogger.toString());
    }

    private Callable<MavenExecutionPlan> createEPFuture(final ProjectSegment projectSegment, final Set<Artifact> projectArtifacts) {
        return new Callable<MavenExecutionPlan>(){

            @Override
            public MavenExecutionPlan call() throws Exception {
                return LifecycleWeaveBuilder.this.builderCommon.resolveBuildPlan(projectSegment.getSession(), projectSegment.getProject(), projectSegment.getTaskSegment(), projectArtifacts);
            }
        };
    }

    private Callable<ProjectSegment> createCallableForBuildingOneFullModule(final ReactorContext reactorContext, final MavenSession rootSession, final ReactorBuildStatus reactorBuildStatus, final MavenExecutionPlan executionPlan, final ProjectSegment projectBuild, final DependencyContext dependencyContext, final ConcurrentBuildLogger concurrentBuildLogger) {
        return new Callable<ProjectSegment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProjectSegment call() throws Exception {
                Iterator<ExecutionPlanItem> planItems = executionPlan.iterator();
                ExecutionPlanItem current = planItems.hasNext() ? planItems.next() : null;
                ThreadLockedArtifact threadLockedArtifact = (ThreadLockedArtifact)projectBuild.getProject().getArtifact();
                if (threadLockedArtifact != null) {
                    threadLockedArtifact.attachToThread();
                }
                long buildStartTime = System.currentTimeMillis();
                if (reactorBuildStatus.isHaltedOrBlacklisted(projectBuild.getProject())) {
                    LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectSkipped, projectBuild.getSession(), null);
                    return null;
                }
                LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, projectBuild.getSession(), null);
                Collection dependencyLinks = LifecycleWeaveBuilder.this.getUpstreamReactorDependencies(projectBuild);
                try {
                    PhaseRecorder phaseRecorder = new PhaseRecorder(projectBuild.getProject());
                    long totalMojoTime = 0L;
                    while (current != null && !reactorBuildStatus.isHaltedOrBlacklisted(projectBuild.getProject())) {
                        ExecutionPlanItem nextPlanItem;
                        BuildLogItem builtLogItem = concurrentBuildLogger.createBuildLogItem(projectBuild.getProject(), current);
                        Schedule schedule = current.getSchedule();
                        long mojoStart = System.currentTimeMillis();
                        LifecycleWeaveBuilder.this.buildExecutionPlanItem(current, phaseRecorder, schedule, reactorContext, projectBuild, dependencyContext);
                        totalMojoTime += System.currentTimeMillis() - mojoStart;
                        current.setComplete();
                        builtLogItem.setComplete();
                        ExecutionPlanItem executionPlanItem = nextPlanItem = planItems.hasNext() ? planItems.next() : null;
                        if (nextPlanItem != null && phaseRecorder.isDifferentPhase(nextPlanItem.getMojoExecution())) {
                            Schedule scheduleOfNext = nextPlanItem.getSchedule();
                            if (scheduleOfNext == null || !scheduleOfNext.isParallel()) {
                                LifecycleWeaveBuilder.this.waitForAppropriateUpstreamExecutionsToFinish(builtLogItem, nextPlanItem, projectBuild, scheduleOfNext);
                            }
                            for (ArtifactLink dependencyLink : dependencyLinks) {
                                dependencyLink.resolveFromUpstream();
                            }
                        }
                        current = nextPlanItem;
                    }
                    BuildSuccess summary = new BuildSuccess(projectBuild.getProject(), totalMojoTime);
                    reactorContext.getResult().addBuildSummary(summary);
                    LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, projectBuild.getSession(), null);
                }
                catch (Exception e) {
                    LifecycleWeaveBuilder.this.builderCommon.handleBuildError(reactorContext, rootSession, projectBuild.getProject(), e, buildStartTime);
                }
                finally {
                    if (current != null) {
                        executionPlan.forceAllComplete();
                    }
                }
                return null;
            }
        };
    }

    private void waitForAppropriateUpstreamExecutionsToFinish(BuildLogItem builtLogItem, ExecutionPlanItem nextPlanItem, ProjectSegment projectBuild, Schedule scheduleOfNext) throws InterruptedException {
        for (MavenProject upstreamProject : projectBuild.getImmediateUpstreamProjects()) {
            String nextPhase;
            MavenExecutionPlan upstreamPlan = this.executionPlans.get(upstreamProject);
            ExecutionPlanItem upstream = upstreamPlan.findLastInPhase(nextPhase = scheduleOfNext != null && scheduleOfNext.hasUpstreamPhaseDefined() ? scheduleOfNext.getUpstreamPhase() : nextPlanItem.getLifecyclePhase());
            if (upstream != null) {
                long startWait = System.currentTimeMillis();
                upstream.waitUntilDone();
                builtLogItem.addWait(upstreamProject, upstream, startWait);
                continue;
            }
            if (!upstreamPlan.containsPhase(nextPhase)) {
                builtLogItem.addDependency(upstreamProject, "No phase tracking possible ");
                upstreamPlan.waitUntilAllDone();
                continue;
            }
            builtLogItem.addDependency(upstreamProject, "No schedule");
        }
    }

    private Collection<ArtifactLink> getUpstreamReactorDependencies(ProjectSegment projectBuild) {
        ArrayList<ArtifactLink> result = new ArrayList<ArtifactLink>();
        for (MavenProject upstreamProject : projectBuild.getTransitiveUpstreamProjects()) {
            Artifact dependencyArtifact;
            Artifact upStreamTestScopedArtifact;
            Artifact dependencyArtifact2;
            Artifact upStreamArtifact = upstreamProject.getArtifact();
            if (upStreamArtifact != null && (dependencyArtifact2 = LifecycleWeaveBuilder.findDependency(projectBuild.getProject(), upStreamArtifact)) != null) {
                result.add(new ArtifactLink(dependencyArtifact2, upStreamArtifact));
            }
            if ((upStreamTestScopedArtifact = this.findTestScopedArtifact(upstreamProject)) == null || (dependencyArtifact = LifecycleWeaveBuilder.findDependency(projectBuild.getProject(), upStreamArtifact)) == null) continue;
            result.add(new ArtifactLink(dependencyArtifact, upStreamTestScopedArtifact));
        }
        return result;
    }

    private Artifact findTestScopedArtifact(MavenProject upstreamProject) {
        if (upstreamProject == null) {
            return null;
        }
        List<Artifact> artifactList = upstreamProject.getAttachedArtifacts();
        for (Artifact artifact : artifactList) {
            if (!"test".equals(artifact.getScope())) continue;
            return artifact;
        }
        return null;
    }

    private static boolean isThreadLockedAndEmpty(Artifact artifact) {
        return artifact instanceof ThreadLockedArtifact && !((ThreadLockedArtifact)artifact).hasReal();
    }

    private static Artifact findDependency(MavenProject project, Artifact upStreamArtifact) {
        if (upStreamArtifact == null || LifecycleWeaveBuilder.isThreadLockedAndEmpty(upStreamArtifact)) {
            return null;
        }
        String key = ArtifactUtils.key((String)upStreamArtifact.getGroupId(), (String)upStreamArtifact.getArtifactId(), (String)upStreamArtifact.getVersion());
        Set<Artifact> deps = project.getDependencyArtifacts();
        for (Artifact dep : deps) {
            String depKey = ArtifactUtils.key((String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion());
            if (!key.equals(depKey)) continue;
            return dep;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExecutionPlanItem(ExecutionPlanItem current, PhaseRecorder phaseRecorder, Schedule schedule, ReactorContext reactorContext, ProjectSegment projectBuild, DependencyContext dependencyContext) throws LifecycleExecutionException {
        if (schedule != null && schedule.isMojoSynchronized()) {
            Plugin plugin = current.getPlugin();
            synchronized (plugin) {
                this.buildExecutionPlanItem(reactorContext, current, projectBuild, dependencyContext, phaseRecorder);
            }
        } else {
            this.buildExecutionPlanItem(reactorContext, current, projectBuild, dependencyContext, phaseRecorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExecutionPlanItem(ReactorContext reactorContext, ExecutionPlanItem node, ProjectSegment projectBuild, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        MavenProject currentProject = projectBuild.getProject();
        long buildStartTime = System.currentTimeMillis();
        CurrentPhaseForThread.setPhase(node.getLifecyclePhase());
        MavenSession sessionForThisModule = projectBuild.getSession();
        try {
            if (reactorContext.getReactorBuildStatus().isHaltedOrBlacklisted(currentProject)) {
                return;
            }
            BuilderCommon.attachToThread(currentProject);
            this.mojoExecutor.execute(sessionForThisModule, node.getMojoExecution(), reactorContext.getProjectIndex(), dependencyContext, phaseRecorder);
            BuildSuccess summary = new BuildSuccess(currentProject, System.currentTimeMillis() - buildStartTime);
            reactorContext.getResult().addBuildSummary(summary);
        }
        finally {
            Thread.currentThread().setContextClassLoader(reactorContext.getOriginalContextClassLoader());
        }
    }

    public static boolean isWeaveMode(MavenExecutionRequest request) {
        return "true".equals(request.getUserProperties().getProperty("maven3.weaveMode"));
    }

    public static void setWeaveMode(Properties properties) {
        properties.setProperty("maven3.weaveMode", "true");
    }

    static class ArtifactLink {
        private final Artifact artifactInThis;
        private final Artifact upstream;

        ArtifactLink(Artifact artifactInThis, Artifact upstream) {
            this.artifactInThis = artifactInThis;
            this.upstream = upstream;
        }

        public void resolveFromUpstream() {
            this.artifactInThis.setFile(this.upstream.getFile());
            this.artifactInThis.setRepository(this.upstream.getRepository());
            this.artifactInThis.setResolved(true);
        }
    }
}

