/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ResolutionErrorHandler.class)
public class DefaultResolutionErrorHandler
implements ResolutionErrorHandler {
    @Override
    public void throwErrors(ArtifactResolutionRequest request, ArtifactResolutionResult result) throws ArtifactResolutionException {
        if (result.hasMetadataResolutionExceptions()) {
            throw result.getMetadataResolutionException(0);
        }
        if (result.hasCircularDependencyExceptions()) {
            throw result.getCircularDependencyException(0);
        }
        if (result.hasVersionRangeViolations()) {
            throw result.getVersionRangeViolation(0);
        }
        if (result.hasErrorArtifactExceptions()) {
            throw result.getErrorArtifactExceptions().get(0);
        }
        if (result.hasMissingArtifacts()) {
            throw new MultipleArtifactsNotFoundException(request.getArtifact(), DefaultResolutionErrorHandler.toList(result.getArtifacts()), result.getMissingArtifacts(), request.getRemoteRepositories());
        }
        if (result.hasExceptions()) {
            throw new ArtifactResolutionException("Unknown error during artifact resolution, " + request + ", " + result.getExceptions(), request.getArtifact(), request.getRemoteRepositories());
        }
    }

    private static <T> List<T> toList(Collection<T> items) {
        return items != null ? new ArrayList<T>(items) : null;
    }
}

