/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven;

import java.io.FileNotFoundException;
import org.gradle.mvn3.org.codehaus.plexus.logging.Logger;
import org.gradle.mvn3.org.sonatype.aether.AbstractRepositoryListener;
import org.gradle.mvn3.org.sonatype.aether.RepositoryEvent;
import org.gradle.mvn3.org.sonatype.aether.transfer.MetadataNotFoundException;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    public LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.logger.info("Installing " + event.getArtifact().getFile() + " to " + event.getFile());
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.logger.debug("Installing " + event.getMetadata() + " to " + event.getFile());
    }

    public void metadataResolved(RepositoryEvent event) {
        Exception e = event.getException();
        if (e != null) {
            if (e instanceof MetadataNotFoundException) {
                this.logger.debug(e.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            } else {
                this.logger.warn(e.getMessage());
            }
        }
    }

    public void metadataInvalid(RepositoryEvent event) {
        Exception exception = event.getException();
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The metadata ");
        if (event.getMetadata().getFile() != null) {
            buffer.append(event.getMetadata().getFile());
        } else {
            buffer.append(event.getMetadata());
        }
        if (exception instanceof FileNotFoundException) {
            buffer.append(" is inaccessible");
        } else {
            buffer.append(" is invalid");
        }
        if (exception != null) {
            buffer.append(": ");
            buffer.append(exception.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer.toString(), (Throwable)exception);
        } else {
            this.logger.warn(buffer.toString());
        }
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The POM for ");
        buffer.append(event.getArtifact());
        buffer.append(" is invalid, transitive dependencies (if any) will not be available");
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer + ": " + event.getException().getMessage());
        } else {
            this.logger.warn(buffer + ", enable debug logging for more details");
        }
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.logger.warn("The POM for " + event.getArtifact() + " is missing, no dependency information available");
    }
}

