/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mortbay.jetty.annotations.AnnotationCollection;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.plus.annotation.RunAsCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.util.IntrospectionUtil;

public class AnnotationParser {
    public static void parseAnnotations(WebAppContext webApp, Class clazz, RunAsCollection runAs, InjectionCollection injections, LifeCycleCallbackCollection callbacks) {
        if (clazz == null) {
            return;
        }
        AnnotationCollection annotations = AnnotationParser.processClass(clazz);
        annotations.setWebAppContext(webApp);
        annotations.processRunAsAnnotations(runAs);
        annotations.processResourcesAnnotations();
        annotations.processResourceAnnotations(injections);
        annotations.processLifeCycleCallbackAnnotations(callbacks);
    }

    static AnnotationCollection processClass(Class clazz) {
        AnnotationCollection collection = new AnnotationCollection();
        if (clazz == null) {
            return collection;
        }
        collection.setTargetClass(clazz);
        collection.addClass(clazz);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            collection.addField(fields[i]);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            collection.addMethod(methods[i]);
        }
        for (Class ancestor = clazz.getSuperclass(); ancestor != null && !ancestor.equals(Object.class); ancestor = ancestor.getSuperclass()) {
            AnnotationParser.processHierarchy(clazz, ancestor, collection);
        }
        return collection;
    }

    private static void processHierarchy(Class targetClazz, Class ancestor, AnnotationCollection collection) {
        if (targetClazz == null) {
            return;
        }
        if (ancestor == null) {
            return;
        }
        collection.addClass(ancestor);
        Method[] methods = ancestor.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getAnnotations().length <= 0 || AnnotationParser.isOverriddenOrHidden(targetClazz, methods[i])) continue;
            collection.addMethod(methods[i]);
        }
        Field[] fields = ancestor.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotations().length <= 0 || AnnotationParser.isHidden(targetClazz, fields[i])) continue;
            collection.addField(fields[i]);
        }
    }

    private static boolean isOverriddenOrHidden(Class derivedClass, Method superclassMethod) {
        if (Modifier.isPrivate(superclassMethod.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(superclassMethod.getModifiers()) || Modifier.isProtected(superclassMethod.getModifiers())) {
            boolean sameSig = false;
            for (Class c = derivedClass; c != superclassMethod.getDeclaringClass() && !sameSig; c = c.getSuperclass()) {
                sameSig = IntrospectionUtil.containsSameMethodSignature((Method)superclassMethod, (Class)c, (boolean)false);
            }
            return sameSig;
        }
        boolean sameSig = false;
        for (Class c = derivedClass; c != superclassMethod.getDeclaringClass() && !sameSig; c = c.getSuperclass()) {
            sameSig = IntrospectionUtil.containsSameMethodSignature((Method)superclassMethod, (Class)c, (boolean)true);
        }
        return sameSig;
    }

    private static boolean isHidden(Class derivedClass, Field superclassField) {
        if (Modifier.isPrivate(superclassField.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(superclassField.getModifiers()) || Modifier.isProtected(superclassField.getModifiers())) {
            boolean hidden = false;
            Class c = derivedClass;
            while (!c.equals(superclassField.getDeclaringClass()) && !hidden) {
                hidden = IntrospectionUtil.containsSameFieldName((Field)superclassField, (Class)c, (boolean)false);
                c = c.getSuperclass();
            }
            return hidden;
        }
        boolean hidden = false;
        Class c = derivedClass;
        while (!c.equals(superclassField.getDeclaringClass()) && !hidden) {
            hidden = IntrospectionUtil.containsSameFieldName((Field)superclassField, (Class)c, (boolean)true);
        }
        return hidden;
    }
}

