/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.settings.building;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.mvn3.org.apache.maven.settings.Settings;
import org.gradle.mvn3.org.apache.maven.settings.building.DefaultSettingsBuildingResult;
import org.gradle.mvn3.org.apache.maven.settings.building.DefaultSettingsProblemCollector;
import org.gradle.mvn3.org.apache.maven.settings.building.FileSettingsSource;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsBuilder;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsBuildingRequest;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsBuildingResult;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsProblem;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsProblemCollector;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsSource;
import org.gradle.mvn3.org.apache.maven.settings.io.SettingsParseException;
import org.gradle.mvn3.org.apache.maven.settings.io.SettingsReader;
import org.gradle.mvn3.org.apache.maven.settings.io.SettingsWriter;
import org.gradle.mvn3.org.apache.maven.settings.merge.MavenSettingsMerger;
import org.gradle.mvn3.org.apache.maven.settings.validation.SettingsValidator;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.InterpolationException;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SettingsBuilder.class)
public class DefaultSettingsBuilder
implements SettingsBuilder {
    @Requirement
    private SettingsReader settingsReader;
    @Requirement
    private SettingsWriter settingsWriter;
    @Requirement
    private SettingsValidator settingsValidator;
    private MavenSettingsMerger settingsMerger = new MavenSettingsMerger();

    public DefaultSettingsBuilder setSettingsReader(SettingsReader settingsReader) {
        this.settingsReader = settingsReader;
        return this;
    }

    public DefaultSettingsBuilder setSettingsWriter(SettingsWriter settingsWriter) {
        this.settingsWriter = settingsWriter;
        return this;
    }

    public DefaultSettingsBuilder setSettingsValidator(SettingsValidator settingsValidator) {
        this.settingsValidator = settingsValidator;
        return this;
    }

    @Override
    public SettingsBuildingResult build(SettingsBuildingRequest request) throws SettingsBuildingException {
        File file;
        DefaultSettingsProblemCollector problems = new DefaultSettingsProblemCollector(null);
        SettingsSource globalSettingsSource = this.getSettingsSource(request.getGlobalSettingsFile(), request.getGlobalSettingsSource());
        Settings globalSettings = this.readSettings(globalSettingsSource, request, problems);
        SettingsSource userSettingsSource = this.getSettingsSource(request.getUserSettingsFile(), request.getUserSettingsSource());
        Settings userSettings = this.readSettings(userSettingsSource, request, problems);
        this.settingsMerger.merge(userSettings, globalSettings, "global-level");
        problems.setSource("");
        userSettings = this.interpolate(userSettings, request, problems);
        String localRepository = userSettings.getLocalRepository();
        if (localRepository != null && localRepository.length() > 0 && !(file = new File(localRepository)).isAbsolute() && file.getPath().startsWith(File.separator)) {
            userSettings.setLocalRepository(file.getAbsolutePath());
        }
        if (this.hasErrors(problems.getProblems())) {
            throw new SettingsBuildingException(problems.getProblems());
        }
        return new DefaultSettingsBuildingResult(userSettings, problems.getProblems());
    }

    private boolean hasErrors(List<SettingsProblem> problems) {
        if (problems != null) {
            for (SettingsProblem problem : problems) {
                if (SettingsProblem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private SettingsSource getSettingsSource(File settingsFile, SettingsSource settingsSource) {
        if (settingsSource != null) {
            return settingsSource;
        }
        if (settingsFile != null && settingsFile.exists()) {
            return new FileSettingsSource(settingsFile);
        }
        return null;
    }

    private Settings readSettings(SettingsSource settingsSource, SettingsBuildingRequest request, DefaultSettingsProblemCollector problems) {
        Settings settings;
        if (settingsSource == null) {
            return new Settings();
        }
        problems.setSource(settingsSource.getLocation());
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.gradle.mvn3.org.apache.maven.settings.io.isStrict", Boolean.TRUE);
            try {
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
            }
            catch (SettingsParseException e) {
                options = Collections.singletonMap("org.gradle.mvn3.org.apache.maven.settings.io.isStrict", Boolean.FALSE);
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
                problems.add(SettingsProblem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            }
        }
        catch (SettingsParseException e) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-parseable settings " + settingsSource.getLocation() + ": " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            return new Settings();
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-readable settings " + settingsSource.getLocation() + ": " + e.getMessage(), -1, -1, e);
            return new Settings();
        }
        this.settingsValidator.validate(settings, problems);
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuildingRequest request, SettingsProblemCollector problems) {
        Settings result;
        StringWriter writer = new StringWriter(4096);
        try {
            this.settingsWriter.write(writer, null, settings);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize settings to memory", e);
        }
        String serializedSettings = writer.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(request.getUserProperties()));
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(request.getSystemProperties()));
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.WARNING, "Failed to use environment variables for interpolation: " + e.getMessage(), -1, -1, e);
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            public Object execute(String expression, Object value) {
                if (value != null) {
                    value = value.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                    return value;
                }
                return null;
            }
        });
        try {
            serializedSettings = interpolator.interpolate(serializedSettings, "settings");
        }
        catch (InterpolationException e) {
            problems.add(SettingsProblem.Severity.ERROR, "Failed to interpolate settings: " + e.getMessage(), -1, -1, (Exception)((Object)e));
            return settings;
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.gradle.mvn3.org.apache.maven.settings.io.isStrict", Boolean.FALSE);
            result = this.settingsReader.read(new StringReader(serializedSettings), options);
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.ERROR, "Failed to interpolate settings: " + e.getMessage(), -1, -1, e);
            return settings;
        }
        return result;
    }
}

