/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import org.gradle.api.GradleException;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.scala.AntScalaCompiler;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCompilerFactory
implements CompilerFactory<ScalaJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final IsolatedAntBuilder antBuilder;
    private final JavaCompilerFactory javaCompilerFactory;
    private final CompilerDaemonFactory compilerDaemonFactory;

    public ScalaCompilerFactory(ProjectInternal project, IsolatedAntBuilder antBuilder, JavaCompilerFactory javaCompilerFactory, CompilerDaemonFactory compilerDaemonFactory) {
        this.project = project;
        this.antBuilder = antBuilder;
        this.javaCompilerFactory = javaCompilerFactory;
        this.compilerDaemonFactory = compilerDaemonFactory;
    }

    public Compiler<ScalaJavaJointCompileSpec> newCompiler(ScalaJavaJointCompileSpec spec) {
        Object scalaCompiler;
        ScalaCompileOptions scalaOptions = spec.getScalaCompileOptions();
        if (scalaOptions.isUseAnt()) {
            AntScalaCompiler scalaCompiler2 = new AntScalaCompiler(this.antBuilder);
            Compiler javaCompiler = this.javaCompilerFactory.createForJointCompilation(spec.getCompileOptions());
            return new NormalizingScalaCompiler(new DefaultScalaJavaJointCompiler(scalaCompiler2, (Compiler<JavaCompileSpec>)javaCompiler));
        }
        if (!scalaOptions.isFork()) {
            throw new GradleException("The Zinc based Scala compiler ('scalaCompileOptions.useAnt=false') requires forking ('scalaCompileOptions.fork=true'), but the latter is set to 'false'.");
        }
        try {
            scalaCompiler = (Compiler)this.getClass().getClassLoader().loadClass("org.gradle.api.internal.tasks.scala.jdk6.ZincScalaCompiler").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Failed to load org.gradle.api.internal.tasks.scala.jdk6.ZincScalaCompiler", e);
        }
        scalaCompiler = new DaemonScalaCompiler(this.project.getRootProject().getProjectDir(), (Compiler<ScalaJavaJointCompileSpec>)scalaCompiler, this.compilerDaemonFactory);
        return new NormalizingScalaCompiler((Compiler<ScalaJavaJointCompileSpec>)scalaCompiler);
    }
}

