/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.gradle.language.base.internal.compile.Compiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonScalaCompiler
extends AbstractDaemonCompiler<ScalaJavaJointCompileSpec> {
    public DaemonScalaCompiler(File daemonWorkingDir, Compiler<ScalaJavaJointCompileSpec> delegate, CompilerDaemonFactory daemonFactory) {
        super(daemonWorkingDir, delegate, daemonFactory);
    }

    protected DaemonForkOptions toDaemonOptions(ScalaJavaJointCompileSpec spec) {
        return this.createJavaForkOptions(spec).mergeWith(this.createScalaForkOptions(spec));
    }

    private DaemonForkOptions createJavaForkOptions(ScalaJavaJointCompileSpec spec) {
        ForkOptions options = spec.getCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs());
    }

    private DaemonForkOptions createScalaForkOptions(ScalaJavaJointCompileSpec spec) {
        ScalaForkOptions options = spec.getScalaCompileOptions().getForkOptions();
        List<String> sharedPackages = Arrays.asList("scala", "com.typesafe.zinc", "xsbti", "com.sun.tools.javac");
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs(), spec.getZincClasspath(), sharedPackages);
    }
}

