/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativebinaries.internal.LinkerSpec;
import org.gradle.nativebinaries.internal.StaticLibraryArchiverSpec;
import org.gradle.nativebinaries.language.assembler.internal.AssembleSpec;
import org.gradle.nativebinaries.language.c.internal.CCompileSpec;
import org.gradle.nativebinaries.language.cpp.internal.CppCompileSpec;
import org.gradle.nativebinaries.language.objectivec.internal.ObjectiveCCompileSpec;
import org.gradle.nativebinaries.language.objectivecpp.internal.ObjectiveCppCompileSpec;
import org.gradle.nativebinaries.language.rc.internal.WindowsResourceCompileSpec;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.VisualCpp;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.DefaultCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.ExtendableToolChain;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.NativeCompileSpec;
import org.gradle.nativebinaries.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativebinaries.toolchain.internal.PlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolChainAvailability;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.nativebinaries.toolchain.internal.UnavailablePlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.Assembler;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.CCompiler;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.CppCompiler;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.LibExeStaticLibraryArchiver;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.LinkExeLinker;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.WindowsResourceCompiler;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.nativebinaries.toolchain.internal.tools.CommandLineToolConfigurationInternal;
import org.gradle.nativebinaries.toolchain.internal.tools.DefaultCommandLineToolConfiguration;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualCppToolChain
extends ExtendableToolChain
implements VisualCpp,
ToolChainInternal {
    private final String name;
    protected final OperatingSystem operatingSystem;
    private final FileResolver fileResolver;
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualCppToolChain.class);
    public static final String DEFAULT_NAME = "visualCpp";
    private final ExecActionFactory execActionFactory;
    private final VisualStudioLocator visualStudioLocator;
    private final WindowsSdkLocator windowsSdkLocator;
    private File installDir;
    private File windowsSdkDir;
    private VisualCppInstall visualCpp;
    private WindowsSdk windowsSdk;
    private ToolChainAvailability availability;

    public VisualCppToolChain(String name, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, VisualStudioLocator visualStudioLocator, WindowsSdkLocator windowsSdkLocator, Instantiator instantiator) {
        super(CommandLineToolConfigurationInternal.class, name, operatingSystem, fileResolver, instantiator);
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"cCompiler"}));
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"cppCompiler"}));
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"linker"}));
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"staticLibArchiver"}));
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"assembler"}));
        this.add(instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{"rcCompiler"}));
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
        this.execActionFactory = execActionFactory;
        this.visualStudioLocator = visualStudioLocator;
        this.windowsSdkLocator = windowsSdkLocator;
    }

    protected String getTypeName() {
        return "Visual Studio";
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(Object installDirPath) {
        this.installDir = this.resolve(installDirPath);
    }

    public File getWindowsSdkDir() {
        return this.windowsSdkDir;
    }

    public void setWindowsSdkDir(Object windowsSdkDirPath) {
        this.windowsSdkDir = this.resolve(windowsSdkDirPath);
    }

    public PlatformToolChain select(Platform targetPlatform) {
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable(this.getAvailability());
        if (this.visualCpp != null && !this.visualCpp.isSupportedPlatform(targetPlatform)) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
        }
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolChain(result);
        }
        return new VisualCppPlatformToolChain(this.getAsMap(), this.visualCpp, this.windowsSdk, targetPlatform);
    }

    private ToolChainAvailability getAvailability() {
        if (this.availability == null) {
            this.availability = new ToolChainAvailability();
            this.checkAvailable(this.availability);
        }
        return this.availability;
    }

    private void checkAvailable(ToolChainAvailability availability) {
        if (!this.operatingSystem.isWindows()) {
            availability.unavailable("Visual Studio is not available on this operating system.");
            return;
        }
        VisualStudioLocator.SearchResult visualStudioSearchResult = this.visualStudioLocator.locateVisualStudioInstalls(this.installDir);
        availability.mustBeAvailable(visualStudioSearchResult);
        if (visualStudioSearchResult.isAvailable()) {
            this.visualCpp = visualStudioSearchResult.getVisualStudio().getVisualCpp();
        }
        WindowsSdkLocator.SearchResult windowsSdkSearchResult = this.windowsSdkLocator.locateWindowsSdks(this.windowsSdkDir);
        availability.mustBeAvailable(windowsSdkSearchResult);
        if (windowsSdkSearchResult.isAvailable()) {
            this.windowsSdk = windowsSdkSearchResult.getSdk();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return String.format("Tool chain '%s' (%s)", this.getName(), this.getTypeName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getOutputType() {
        return String.format("%s-%s", this.getName(), this.operatingSystem.getName());
    }

    public String getExecutableName(String executablePath) {
        return this.operatingSystem.getExecutableName(executablePath);
    }

    public String getSharedLibraryName(String libraryName) {
        return this.operatingSystem.getSharedLibraryName(libraryName);
    }

    public String getStaticLibraryName(String libraryName) {
        return this.operatingSystem.getStaticLibraryName(libraryName);
    }

    protected File resolve(Object path) {
        return this.fileResolver.resolve(path);
    }

    public String getSharedLibraryLinkFileName(String libraryName) {
        return this.getSharedLibraryName(libraryName).replaceFirst("\\.dll$", ".lib");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisualCppPlatformToolChain
    implements PlatformToolChain {
        private SortedMap<String, CommandLineToolConfigurationInternal> commandLineToolConfigurations;
        private final VisualCppInstall visualCpp;
        private final WindowsSdk sdk;
        private final Platform targetPlatform;

        private VisualCppPlatformToolChain(SortedMap<String, CommandLineToolConfigurationInternal> commandLineToolConfigurations, VisualCppInstall visualCpp, WindowsSdk sdk, Platform targetPlatform) {
            this.commandLineToolConfigurations = commandLineToolConfigurations;
            this.visualCpp = visualCpp;
            this.sdk = sdk;
            this.targetPlatform = targetPlatform;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(T spec) {
            if (spec instanceof CppCompileSpec) {
                return this.createCppCompiler();
            }
            if (spec instanceof CCompileSpec) {
                return this.createCCompiler();
            }
            if (spec instanceof ObjectiveCppCompileSpec) {
                throw new RuntimeException("Objective-C++ is not available on the Visual C++ toolchain");
            }
            if (spec instanceof ObjectiveCCompileSpec) {
                throw new RuntimeException("Objective-C is not available on the Visual C++ toolchain");
            }
            if (spec instanceof WindowsResourceCompileSpec) {
                return this.createWindowsResourceCompiler();
            }
            if (spec instanceof AssembleSpec) {
                return this.createAssembler();
            }
            if (spec instanceof LinkerSpec) {
                return this.createLinker();
            }
            if (spec instanceof StaticLibraryArchiverSpec) {
                return this.createStaticLibraryArchiver();
            }
            throw new IllegalArgumentException(String.format("Don't know how to compile from a spec of type %s.", spec.getClass().getSimpleName()));
        }

        public Compiler<CppCompileSpec> createCppCompiler() {
            CommandLineTool commandLineTool = this.tool("C++ compiler", this.visualCpp.getCompiler(this.targetPlatform));
            CppCompiler cppCompiler = new CppCompiler(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("cppCompiler")), this.addIncludePathAndDefinitions(CppCompileSpec.class));
            return new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, ".obj");
        }

        public Compiler<CCompileSpec> createCCompiler() {
            CommandLineTool commandLineTool = this.tool("C compiler", this.visualCpp.getCompiler(this.targetPlatform));
            CCompiler cCompiler = new CCompiler(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("cCompiler")), this.addIncludePathAndDefinitions(CCompileSpec.class));
            return new OutputCleaningCompiler<CCompileSpec>(cCompiler, ".obj");
        }

        public Compiler<AssembleSpec> createAssembler() {
            CommandLineTool commandLineTool = this.tool("Assembler", this.visualCpp.getAssembler(this.targetPlatform));
            return new Assembler(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("assembler")));
        }

        public Compiler<WindowsResourceCompileSpec> createWindowsResourceCompiler() {
            CommandLineTool commandLineTool = this.tool("Windows resource compiler", this.sdk.getResourceCompiler(this.targetPlatform));
            WindowsResourceCompiler windowsResourceCompiler = new WindowsResourceCompiler(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("rcCompiler")), this.addIncludePathAndDefinitions(WindowsResourceCompileSpec.class));
            return new OutputCleaningCompiler<WindowsResourceCompileSpec>(windowsResourceCompiler, ".res");
        }

        public Compiler<LinkerSpec> createLinker() {
            CommandLineTool commandLineTool = this.tool("Linker", this.visualCpp.getLinker(this.targetPlatform));
            return new LinkExeLinker(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("linker")), this.addLibraryPath());
        }

        public Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
            CommandLineTool commandLineTool = this.tool("Static library archiver", this.visualCpp.getArchiver(this.targetPlatform));
            return new LibExeStaticLibraryArchiver(commandLineTool, this.invocation((CommandLineToolConfigurationInternal)this.commandLineToolConfigurations.get("staticLibArchiver")));
        }

        private CommandLineTool tool(String toolName, File exe) {
            return new CommandLineTool(toolName, exe, VisualCppToolChain.this.execActionFactory);
        }

        private CommandLineToolInvocation invocation(CommandLineToolConfigurationInternal commandLineToolConfiguration) {
            DefaultCommandLineToolInvocation invocation = new DefaultCommandLineToolInvocation();
            invocation.addPath(this.visualCpp.getPath(this.targetPlatform));
            invocation.addPath(this.sdk.getBinDir(this.targetPlatform));
            this.clearEnvironmentVars(invocation, "INCLUDE", "CL", "LIBPATH", "LINK", "LIB");
            invocation.addPostArgsAction(commandLineToolConfiguration.getArgAction());
            return invocation;
        }

        private void clearEnvironmentVars(MutableCommandLineToolInvocation invocation, String ... names) {
            Map environmentVariables = Jvm.current().getInheritableEnvironmentVariables(System.getenv());
            for (String name : names) {
                Object value = environmentVariables.get(name);
                if (value == null) continue;
                LOGGER.warn("Ignoring value '{}' set for environment variable '{}'.", value, (Object)name);
                invocation.addEnvironmentVar(name, "");
            }
        }

        public String getOutputType() {
            return String.format("%s-%s", VisualCppToolChain.this.getName(), VisualCppToolChain.this.operatingSystem.getName());
        }

        private <T extends NativeCompileSpec> Transformer<T, T> addIncludePathAndDefinitions(Class<T> type) {
            return new Transformer<T, T>(){

                public T transform(T original) {
                    original.include(VisualCppPlatformToolChain.this.visualCpp.getIncludePath(VisualCppPlatformToolChain.this.targetPlatform));
                    original.include(VisualCppPlatformToolChain.this.sdk.getIncludeDirs());
                    for (Map.Entry<String, String> definition : VisualCppPlatformToolChain.this.visualCpp.getDefinitions(VisualCppPlatformToolChain.this.targetPlatform).entrySet()) {
                        original.define(definition.getKey(), definition.getValue());
                    }
                    return original;
                }
            };
        }

        private Transformer<LinkerSpec, LinkerSpec> addLibraryPath() {
            return new Transformer<LinkerSpec, LinkerSpec>(){

                public LinkerSpec transform(LinkerSpec original) {
                    original.libraryPath(VisualCppPlatformToolChain.this.visualCpp.getLibraryPath(VisualCppPlatformToolChain.this.targetPlatform), VisualCppPlatformToolChain.this.sdk.getLibDir(VisualCppPlatformToolChain.this.targetPlatform));
                    return original;
                }
            };
        }
    }
}

