/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.NativeCompileSpec;
import org.gradle.nativebinaries.toolchain.internal.ShortCircuitArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.SingleSourceCompileArgTransformer;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualCppOptionsFileArgTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final CommandLineTool commandLineTool;
    private final ArgsTransformer<T> argsTransFormer;
    private final Transformer<T, T> specTransformer;
    private final CommandLineToolInvocation baseInvocation;

    NativeCompiler(CommandLineTool commandLineTool, CommandLineToolInvocation invocation, ArgsTransformer<T> argsTransFormer, Transformer<T, T> specTransformer) {
        this.argsTransFormer = argsTransFormer;
        this.commandLineTool = commandLineTool;
        this.baseInvocation = invocation;
        this.specTransformer = specTransformer;
    }

    public WorkResult execute(T spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.addPostArgsAction(new VisualCppOptionsFileArgTransformer(spec.getTempDir()));
        Transformer<List<String>, File> outputFileArgTransformer = new Transformer<List<String>, File>(){

            public List<String> transform(File outputFile) {
                return Arrays.asList("/Fo" + outputFile.getAbsolutePath());
            }
        };
        for (File sourceFile : spec.getSourceFiles()) {
            String objectFileNameSuffix = ".obj";
            SingleSourceCompileArgTransformer<NativeCompileSpec> argTransformer = new SingleSourceCompileArgTransformer<NativeCompileSpec>(sourceFile, objectFileNameSuffix, new ShortCircuitArgsTransformer<T>(this.argsTransFormer), true, outputFileArgTransformer);
            invocation.setArgs(argTransformer.transform((NativeCompileSpec)this.specTransformer.transform(spec)));
            invocation.setWorkDirectory(spec.getObjectFileDir());
            this.commandLineTool.execute(invocation);
        }
        return new SimpleWorkResult(!spec.getSourceFiles().isEmpty());
    }
}

