/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativebinaries.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativebinaries.language.assembler.internal.AssembleSpec;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.EscapeUserArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Assembler
implements Compiler<AssembleSpec> {
    private final CommandLineTool commandLineTool;
    private final CommandLineToolInvocation baseInvocation;

    public Assembler(CommandLineTool commandLineTool, CommandLineToolInvocation invocation) {
        this.commandLineTool = commandLineTool;
        this.baseInvocation = invocation;
    }

    public WorkResult execute(AssembleSpec spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.setWorkDirectory(spec.getObjectFileDir());
        for (File sourceFile : spec.getSourceFiles()) {
            invocation.setArgs(new AssemblerArgsTransformer(sourceFile).transform(spec));
            this.commandLineTool.execute(invocation);
        }
        return new SimpleWorkResult(!spec.getSourceFiles().isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssemblerArgsTransformer
    implements ArgsTransformer<AssembleSpec> {
        private final File inputFile;

        public AssemblerArgsTransformer(File inputFile) {
            this.inputFile = inputFile;
        }

        public List<String> transform(AssembleSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
            args.add("/nologo");
            args.add("/c");
            File outputFile = new CompilerOutputFileNamingScheme().withOutputBaseFolder(spec.getObjectFileDir()).withObjectFileNameSuffix(".obj").map(this.inputFile);
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            args.add("/Fo" + outputFile);
            args.add(this.inputFile.getAbsolutePath());
            return args;
        }
    }
}

